#! /bin/bash -e

mkdir -p vendor
curl -o vendor/compose-spec.json https://raw.githubusercontent.com/compose-spec/compose-go/main/schema/compose-spec.json
curl -s "https://api.github.com/repos/compose-spec/compose-go/branches/main" | grep '"sha":' | head -n 1 | cut -d '"' -f 4 > vendor/commit-id

CONTAINER=${CONTAINER:-container}

${CONTAINER} run \
    --memory 4g \
    -it \
    --rm \
    -v ${PWD}:/proj \
    -w /proj \
    node:latest \
    npx -y \
    quicktype \
    --src-lang schema \
    --lang swift \
    --access-level public \
    --top-level Compose \
    --out Sources/ComposeSpec/Compose.swift \
    vendor/compose-spec.json
