import ArgumentParser
import ComposeSpec
import Foundation

@main
struct swift_docker_compose_types: ParsableCommand {
    @Argument
    var composePathnames: [String] = []

    mutating func run() throws {
        for composePathname in composePathnames {
            load(from: composePathname)
        }
    }

    private func load(from filePath: String) {
        do {
            let url = URL(fileURLWithPath: filePath)
            let compose = try ComposeLoader.load(fileUrl: url)
            print(compose)
        } catch let DecodingError.keyNotFound(key, context) {
            print("Missing key: \(key.stringValue) – \(context.debugDescription)")
            print("Coding path: \(context.codingPath.map(\.stringValue).joined(separator: " -> "))")
        } catch let DecodingError.typeMismatch(type, context) {
            print("Type mismatch for type: \(type) – \(context.debugDescription)")
        } catch let DecodingError.valueNotFound(value, context) {
            print("Value \(value) not found – \(context.debugDescription)")
        } catch {
            print("Other decoding error: \(error)")
        }
    }
}
