import Foundation
import Yams

public class ComposeLoader {
    public enum Error: Swift.Error, CustomStringConvertible {
        case invalidEncoding

        public var description: String {
            switch self {
            case .invalidEncoding:
                "input data is not valid UTF-8"
            }
        }
    }

    public static func load(fileUrl: URL) throws -> Compose {
        guard let composeYaml = try? String(contentsOf: fileUrl, encoding: .utf8) else {
            throw Error.invalidEncoding
        }

        let decoder = YAMLDecoder()
        return try decoder.decode(Compose.self, from: composeYaml)
    }

    public static func load(data: Data) throws -> Compose {
        guard let composeYaml = String(data: data, encoding: .utf8) else {
            throw Error.invalidEncoding
        }

        let decoder = YAMLDecoder()
        return try decoder.decode(Compose.self, from: composeYaml)
    }

    public static func load(string composeYaml: String) throws -> Compose {
        let decoder = YAMLDecoder()
        return try decoder.decode(Compose.self, from: composeYaml)
    }
}