# Docker Compose model types for Swift

This package provides model types and a loader for Docker Compose YAML files.

To generate an updated Compose.swift model type file from the [Docker Compose JSON schema](https://github.com/compose-spec/compose-go/blob/main/schema/compose-spec.json), run:

```
./generate-model.sh
```

The only patches to the generated code that are necessary at present are:

```diff
% diff Sources/ComposeSpec/Compose.swift Sources/ComposeSpec/Compose-orig.swift
379,380c379,380
<     public func hash(into hasher: inout Hasher) {
<         hasher.combine(0)
---
>     public var hashValue: Int {
>             return 0
398c398
< final class JSONCodingKey: CodingKey {
---
> class JSONCodingKey: CodingKey {
```

To test Compose file loading, run:

```bash
./.build/arm64-apple-macosx/debug/swift-docker-compose-types samples/docker-compose-nobuild.yaml
```