#include <ArduinoIoTCloud.h>
#include <Arduino_ConnectionHandler.h>

float temperature = NAN;
WiFiConnectionHandler ArduinoIoTPreferredConnection("ssid", "pwd");

void setup() {
  Serial.begin(9600);
  delay(5000); 
  ArduinoCloud.addPropertyReal(temperature, "temperature", Permission::ReadWrite).onSync(CLOUD_WINS).onUpdate(onTemperatureChange);
  Serial.println(String("Temperature: ") + String(temperature)); 
  ArduinoCloud.begin(ArduinoIoTPreferredConnection);
  setDebugMessageLevel(2);
  ArduinoCloud.printDebugInfo();
}

void loop() {
  ArduinoCloud.update();
}

void onTemperatureChange()  {
  Serial.println(String("Temperature changed: ") + String(temperature)); 
}
