import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Reproduction {

  private Map<String, String> func(Set<Entity> entities) {

    return Optional.ofNullable(entities)
      .map(t -> t.stream().collect(Collectors.toMap(Entity::getName, Entity::getId))
      ).orElse(Collections.emptyMap());
  }

  private

  class Entity {

    private String id;

    private String name;

    public String getId() {

      return id;
    }

    public String getName() {

      return name;
    }

  }
}
