package io.meshcloud.entitymodel_projection_issue

import io.meshcloud.entitymodel_projection_issue.model.EntityWithIsFieldRepository
import io.meshcloud.entitymodel_projection_issue.model.TestEntity
import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc
import org.springframework.boot.test.context.SpringBootTest
import org.springframework.test.web.servlet.MockMvc
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get
import org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath
import org.springframework.test.web.servlet.result.MockMvcResultMatchers.status

@SpringBootTest
@AutoConfigureMockMvc
class EntityModelTests {

    @Autowired
    lateinit var api: MockMvc

    @Autowired
    private lateinit var entityWithIsFieldRepository: EntityWithIsFieldRepository


    @BeforeEach
    fun setup() {
        entityWithIsFieldRepository.save(TestEntity(
                id = 1,
                mandatoryValue = "test",
                isGreat = true
        ))
    }

    @Test
    fun failedMappingWithIs() {
        val response = api.perform(get("/withIs"))
        response.andExpect(status().is2xxSuccessful)
        response.andExpect(jsonPath("$._embedded.testEntities[0].isValid").value(true))
        response.andExpect(jsonPath("$._embedded.testEntities[0].projectedValue").value("test"))
    }

    @Test
    fun successfulMappingWithoutIs() {
        val response = api.perform(get("/withoutIs"))
        response.andExpect(status().is2xxSuccessful)
        response.andExpect(jsonPath("$._embedded.testEntities[0].isValid").doesNotExist())
        response.andExpect(jsonPath("$._embedded.testEntities[0].isGreat").doesNotExist())
        response.andExpect(jsonPath("$._embedded.testEntities[0].projectedValue").value("test"))
    }

    @Test
    fun successfulMappingWithoutHateoas() {
        val response = api.perform(get("/directProjections"))
        response.andExpect(status().is2xxSuccessful)
        response.andExpect(jsonPath("$.content[0].isValid").value(true))
        response.andExpect(jsonPath("$.content[0].isGreat").value(true))
        response.andExpect(jsonPath("$.content[0].projectedValue").value("test"))
    }

    @Test
    fun successfulMappingWithDirectEntityWithIs() {
        val response = api.perform(get("/entities"))
        response.andExpect(status().is2xxSuccessful)
        response.andExpect(jsonPath("$._embedded.testEntities[0].isValid").value(true))
        response.andExpect(jsonPath("$._embedded.testEntities[0].isGreat").value(true))
        response.andExpect(jsonPath("$._embedded.testEntities[0].mandatoryValue").value("test"))
    }
}
