package io.meshcloud.entitymodel_projection_issue.model

import com.fasterxml.jackson.annotation.JsonProperty
import jakarta.persistence.Entity
import jakarta.persistence.Id
import org.springframework.beans.factory.annotation.Value

@Entity
class TestEntity(
        @Id
        val id: Long,
        val mandatoryValue: String?,

        @get:JsonProperty("isGreat")
        val isGreat: Boolean
) {
    @get:JsonProperty("isValid")
    val isValid: Boolean
        get() = mandatoryValue != null
}

interface EntityWithIsFieldProjection {

    val projectedValue: String?
        @Value("#{target.mandatoryValue}")
        get() = projectedValue

    @get:JsonProperty("isGreat")
    val isGreat: Boolean

    @get:JsonProperty("isValid")
    val isValid: Boolean
}

interface EntityWithoutIsFieldProjection {

    val projectedValue: String?
        @Value("#{target.mandatoryValue}")
        get() = projectedValue

}