package io.meshcloud.entitymodel_projection_issue

import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.boot.autoconfigure.domain.EntityScan
import org.springframework.boot.context.properties.ConfigurationPropertiesScan
import org.springframework.boot.runApplication
import org.springframework.data.jpa.repository.config.EnableJpaRepositories
import org.springframework.hateoas.config.EnableHypermediaSupport

@SpringBootApplication(scanBasePackages = [
	"io.meshcloud.entitymodel_projection_issue"
])
@ConfigurationPropertiesScan(basePackages = [
	"io.meshcloud.entitymodel_projection_issue"
])
@EnableHypermediaSupport(type = [(EnableHypermediaSupport.HypermediaType.HAL)])
@EnableJpaRepositories(basePackages = ["io.meshcloud.entitymodel_projection_issue.model"])
@EntityScan(basePackages = ["io.meshcloud.entitymodel_projection_issue.model"])
class EntitymodelProjectionIssueApplication

fun main(args: Array<String>) {
	runApplication<EntitymodelProjectionIssueApplication>(*args)
}
