package com.sample;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.web.reactive.server.WebTestClient;

import static org.springframework.boot.test.context.SpringBootTest.WebEnvironment.RANDOM_PORT;
import static org.springframework.http.MediaType.TEXT_HTML;

@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = RANDOM_PORT)
public class IndexControllerTest {

    @Autowired
    private WebTestClient webClient;

    @Test
    public void test() {
        webClient.get().uri("/")
                .accept(TEXT_HTML)
                .exchange()
                .expectStatus().isOk()
                .expectHeader().contentType("text/html")
                .expectBody(String.class)
                .isEqualTo("<!DOCTYPE html>\n" +
                        "<html>\n" +
                        "  <head>\n" +
                        "      <title>foobar</title>\n" +
                        "  </head>\n" +
                        "</html>\n");
    }
}
