package com.testproject.controllers;

import com.testproject.model.Animal;
import com.testproject.service.AnimalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

import java.util.List;

@RestController
@RequestMapping
public class DemoController {

    @Autowired
    AnimalService animalService;

    @GetMapping("/")
    public RedirectView toSwagger(RedirectAttributes attributes){
        return new RedirectView("/swagger-ui.html");
    }

    @GetMapping("/animals")
    public ResponseEntity<List<Animal>> listAnimals(){

        return ResponseEntity.status(HttpStatus.OK).body(animalService.listAnimals());
    }
}
