package com.example.demo;

import static org.assertj.core.api.Assertions.*;

import org.junit.Test;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;

public class AutoConfigTest {

	@Test
	public void onlyAutoConfig() {

		new ApplicationContextRunner()
			.withConfiguration(
				AutoConfigurations.of(
					org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration.class,
					com.example.outside_app.JpaRepositoriesAutoConfiguration.class
				))
			.run(ctx -> assertThat(ctx).hasBean("someServiceFromAutoConfig"));
	}

	@Test
	public void onlyUserConfiguration() {
		new ApplicationContextRunner()
			.withUserConfiguration(com.example.demo.a.SomeConfig.class, com.example.demo.b.SomeConfig.class)
			.run(ctx -> {
				assertThat(ctx).hasBean("someServiceFromB");
				assertThat(ctx).hasBean("someServiceFromA");
			});
	}
}
