package com.example.demo;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

// Uncomment the following line to make things work - cumbersome...
//@DependsOn({"flyway", "flywayInitializer"})
@Component
@Slf4j
public class MyComponent {

    @Autowired
    JdbcTemplate jdbcTemplate;

    // Flyway should run before this bean is initialized since this bean depends on JdbcTemplate.
    // However, the bean is being created before Flyway runs, which makes the PostConstruct throw an
    // SQL exception because the schema has not been initialized yet.
    @PostConstruct
    public void postConstruct() {
        log.info("Running @PostConstruct");
        try {
            jdbcTemplate.queryForObject("select myData from db.my_table", String.class);
            log.info("Yay, the database was migrated before @PostConstruct was called");
        } catch (Exception ex) {
            log.error("Oh no, the database was not yet migrated...");
        }
    }
}
