use derive_new::new;
use kinematic_model::config::PositionInit;
use sequence_model::config::SequenceNameString;
use serde::{Deserialize, Serialize};
use ui_model_spi::config::UiSequenceName;

/// Defines a sprite sequence to display.
#[derive(Clone, Debug, Deserialize, PartialEq, Serialize, new)]
#[serde(deny_unknown_fields)]
pub struct UiSpriteLabel {
    /// Position of the label relative to its parent.
    pub position: PositionInit,
    /// `SequenceNameString` that the ui_label should begin with.
    pub sequence: SequenceNameString<UiSequenceName>,
}
