(function() {var type_impls = {
"core":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroI16\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#impl-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new_unchecked\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0, const since 1.34.0\">1.34.0 (const: 1.34.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><h4 class=\"code-header\">pub const unsafe fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.new_unchecked\" class=\"fn\">new_unchecked</a>(n: <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a non-zero without checking whether the value is non-zero.\nThis results in undefined behaviour if the value is zero.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>The value must not be zero.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0, const since 1.47.0\">1.34.0 (const: 1.47.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.new\" class=\"fn\">new</a>(n: <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;Self&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a non-zero if the given value is not zero.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.get\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0, const since 1.34.0\">1.34.0 (const: 1.34.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.get\" class=\"fn\">get</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.i16.html\">i16</a></h4></section></summary><div class=\"docblock\"><p>Returns the value as a primitive type.</p>\n</div></details></div></details>",0,"core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroI16\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#268-281\">source</a><a href=\"#impl-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.leading_zeros\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.53.0, const since 1.53.0\">1.53.0 (const: 1.53.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#268-281\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.leading_zeros\" class=\"fn\">leading_zeros</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u32.html\">u32</a></h4></section></summary><div class=\"docblock\"><p>Returns the number of leading zeros in the binary representation of <code>self</code>.</p>\n<p>On many architectures, this function can perform better than <code>leading_zeros()</code> on the underlying integer type, as special handling of zero can be avoided.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>n = std::num::NonZeroI16::new(-<span class=\"number\">1i16</span>).unwrap();\n\n<span class=\"macro\">assert_eq!</span>(n.leading_zeros(), <span class=\"number\">0</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+n+=+std::num::NonZeroI16::new(-1i16).unwrap();%0A%0Aassert_eq!(n.leading_zeros(),+0);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.trailing_zeros\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.53.0, const since 1.53.0\">1.53.0 (const: 1.53.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#268-281\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.trailing_zeros\" class=\"fn\">trailing_zeros</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.u32.html\">u32</a></h4></section></summary><div class=\"docblock\"><p>Returns the number of trailing zeros in the binary representation\nof <code>self</code>.</p>\n<p>On many architectures, this function can perform better than <code>trailing_zeros()</code> on the underlying integer type, as special handling of zero can be avoided.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<p>Basic usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>n = std::num::NonZeroI16::new(<span class=\"number\">0b0101000</span>).unwrap();\n\n<span class=\"macro\">assert_eq!</span>(n.trailing_zeros(), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+n+=+std::num::NonZeroI16::new(0b0101000).unwrap();%0A%0Aassert_eq!(n.trailing_zeros(),+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroI16\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a><a href=\"#impl-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.abs\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.abs\" class=\"fn\">abs</a>(self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class=\"docblock\"><p>Computes the absolute value of self.\nSee <a href=\"core/primitive.i16.html#method.abs\" title=\"method i16::abs\"><code>i16::abs</code></a>\nfor documentation on overflow behaviour.</p>\n<h5 id=\"example\"><a href=\"#example\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos = NonZeroI16::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg = NonZeroI16::new(-<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(pos, pos.abs());\n<span class=\"macro\">assert_eq!</span>(pos, neg.abs());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos+=+NonZeroI16::new(1)?;%0Alet+neg+=+NonZeroI16::new(-1)?;%0A%0Aassert_eq!(pos,+pos.abs());%0Aassert_eq!(pos,+neg.abs());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_abs\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.checked_abs\" class=\"fn\">checked_abs</a>(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Checked absolute value.\nChecks for overflow and returns <a href=\"core/option/enum.Option.html#variant.None\" title=\"variant core::option::Option::None\"><code>None</code></a> if\n<code>self == NonZeroI16::MIN</code>.\nThe result cannot be zero.</p>\n<h5 id=\"example-1\"><a href=\"#example-1\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos = NonZeroI16::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg = NonZeroI16::new(-<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(pos), neg.checked_abs());\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">None</span>, min.checked_abs());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos+=+NonZeroI16::new(1)?;%0Alet+neg+=+NonZeroI16::new(-1)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0A%0Aassert_eq!(Some(pos),+neg.checked_abs());%0Aassert_eq!(None,+min.checked_abs());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.overflowing_abs\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.overflowing_abs\" class=\"fn\">overflowing_abs</a>(self) -&gt; (<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>, <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>)</h4></section></summary><div class=\"docblock\"><p>Computes the absolute value of self,\nwith overflow information, see\n<a href=\"core/primitive.i16.html#method.overflowing_abs\" title=\"method i16::overflowing_abs\"><code>i16::overflowing_abs</code></a>.</p>\n<h5 id=\"example-2\"><a href=\"#example-2\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos = NonZeroI16::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg = NonZeroI16::new(-<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>((pos, <span class=\"bool-val\">false</span>), pos.overflowing_abs());\n<span class=\"macro\">assert_eq!</span>((pos, <span class=\"bool-val\">false</span>), neg.overflowing_abs());\n<span class=\"macro\">assert_eq!</span>((min, <span class=\"bool-val\">true</span>), min.overflowing_abs());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos+=+NonZeroI16::new(1)?;%0Alet+neg+=+NonZeroI16::new(-1)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0A%0Aassert_eq!((pos,+false),+pos.overflowing_abs());%0Aassert_eq!((pos,+false),+neg.overflowing_abs());%0Aassert_eq!((min,+true),+min.overflowing_abs());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_abs\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.saturating_abs\" class=\"fn\">saturating_abs</a>(self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class=\"docblock\"><p>Saturating absolute value, see\n<a href=\"core/primitive.i16.html#method.saturating_abs\" title=\"method i16::saturating_abs\"><code>i16::saturating_abs</code></a>.</p>\n<h5 id=\"example-3\"><a href=\"#example-3\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos = NonZeroI16::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg = NonZeroI16::new(-<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min_plus = NonZeroI16::new(i16::MIN + <span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroI16::new(i16::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(pos, pos.saturating_abs());\n<span class=\"macro\">assert_eq!</span>(pos, neg.saturating_abs());\n<span class=\"macro\">assert_eq!</span>(max, min.saturating_abs());\n<span class=\"macro\">assert_eq!</span>(max, min_plus.saturating_abs());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos+=+NonZeroI16::new(1)?;%0Alet+neg+=+NonZeroI16::new(-1)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0Alet+min_plus+=+NonZeroI16::new(i16::MIN+%2B+1)?;%0Alet+max+=+NonZeroI16::new(i16::MAX)?;%0A%0Aassert_eq!(pos,+pos.saturating_abs());%0Aassert_eq!(pos,+neg.saturating_abs());%0Aassert_eq!(max,+min.saturating_abs());%0Aassert_eq!(max,+min_plus.saturating_abs());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_abs\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.wrapping_abs\" class=\"fn\">wrapping_abs</a>(self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class=\"docblock\"><p>Wrapping absolute value, see\n<a href=\"core/primitive.i16.html#method.wrapping_abs\" title=\"method i16::wrapping_abs\"><code>i16::wrapping_abs</code></a>.</p>\n<h5 id=\"example-4\"><a href=\"#example-4\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos = NonZeroI16::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg = NonZeroI16::new(-<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(pos, pos.wrapping_abs());\n<span class=\"macro\">assert_eq!</span>(pos, neg.wrapping_abs());\n<span class=\"macro\">assert_eq!</span>(min, min.wrapping_abs());\n<span class=\"macro\">assert_eq!</span>(max, (-max).wrapping_abs());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos+=+NonZeroI16::new(1)?;%0Alet+neg+=+NonZeroI16::new(-1)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0Alet+max+=+NonZeroI16::new(i16::MAX)?;%0A%0Aassert_eq!(pos,+pos.wrapping_abs());%0Aassert_eq!(pos,+neg.wrapping_abs());%0Aassert_eq!(min,+min.wrapping_abs());%0Aassert_eq!(max,+(-max).wrapping_abs());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unsigned_abs\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.unsigned_abs\" class=\"fn\">unsigned_abs</a>(self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroU16.html\" title=\"struct core::num::NonZeroU16\">NonZeroU16</a></h4></section></summary><div class=\"docblock\"><p>Computes the absolute value of self\nwithout any wrapping or panicking.</p>\n<h5 id=\"example-5\"><a href=\"#example-5\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"kw\">let </span>u_pos = NonZeroU16::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>i_pos = NonZeroI16::new(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>i_neg = NonZeroI16::new(-<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>i_min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>u_max = NonZeroU16::new(u16::MAX / <span class=\"number\">2 </span>+ <span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(u_pos, i_pos.unsigned_abs());\n<span class=\"macro\">assert_eq!</span>(u_pos, i_neg.unsigned_abs());\n<span class=\"macro\">assert_eq!</span>(u_max, i_min.unsigned_abs());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Ause+std::num::NonZeroU16;%0A%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+u_pos+=+NonZeroU16::new(1)?;%0Alet+i_pos+=+NonZeroI16::new(1)?;%0Alet+i_neg+=+NonZeroI16::new(-1)?;%0Alet+i_min+=+NonZeroI16::new(i16::MIN)?;%0Alet+u_max+=+NonZeroU16::new(u16::MAX+/+2+%2B+1)?;%0A%0Aassert_eq!(u_pos,+i_pos.unsigned_abs());%0Aassert_eq!(u_pos,+i_neg.unsigned_abs());%0Aassert_eq!(u_max,+i_min.unsigned_abs());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_positive\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.71.0, const since 1.71.0\">1.71.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.is_positive\" class=\"fn\">is_positive</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if <code>self</code> is positive and <code>false</code> if the\nnumber is negative.</p>\n<h5 id=\"example-6\"><a href=\"#example-6\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos_five = NonZeroI16::new(<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg_five = NonZeroI16::new(-<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert!</span>(pos_five.is_positive());\n<span class=\"macro\">assert!</span>(!neg_five.is_positive());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos_five+=+NonZeroI16::new(5)?;%0Alet+neg_five+=+NonZeroI16::new(-5)?;%0A%0Aassert!(pos_five.is_positive());%0Aassert!(!neg_five.is_positive());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_negative\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.71.0, const since 1.71.0\">1.71.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.is_negative\" class=\"fn\">is_negative</a>(self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if <code>self</code> is negative and <code>false</code> if the\nnumber is positive.</p>\n<h5 id=\"example-7\"><a href=\"#example-7\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos_five = NonZeroI16::new(<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg_five = NonZeroI16::new(-<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert!</span>(neg_five.is_negative());\n<span class=\"macro\">assert!</span>(!pos_five.is_negative());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos_five+=+NonZeroI16::new(5)?;%0Alet+neg_five+=+NonZeroI16::new(-5)?;%0A%0Aassert!(neg_five.is_negative());%0Aassert!(!pos_five.is_negative());%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_neg\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.71.0, const since 1.71.0\">1.71.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.checked_neg\" class=\"fn\">checked_neg</a>(self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Checked negation. Computes <code>-self</code>,\nreturning <code>None</code> if <code>self == NonZeroI16::MIN</code>.</p>\n<h5 id=\"example-8\"><a href=\"#example-8\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos_five = NonZeroI16::new(<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg_five = NonZeroI16::new(-<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(pos_five.checked_neg(), <span class=\"prelude-val\">Some</span>(neg_five));\n<span class=\"macro\">assert_eq!</span>(min.checked_neg(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos_five+=+NonZeroI16::new(5)?;%0Alet+neg_five+=+NonZeroI16::new(-5)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0A%0Aassert_eq!(pos_five.checked_neg(),+Some(neg_five));%0Aassert_eq!(min.checked_neg(),+None);%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.overflowing_neg\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.71.0, const since 1.71.0\">1.71.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.overflowing_neg\" class=\"fn\">overflowing_neg</a>(self) -&gt; (<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>, <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>)</h4></section></summary><div class=\"docblock\"><p>Negates self, overflowing if this is equal to the minimum value.</p>\n<p>See <a href=\"core/primitive.i16.html#method.overflowing_neg\" title=\"method i16::overflowing_neg\"><code>i16::overflowing_neg</code></a>\nfor documentation on overflow behaviour.</p>\n<h5 id=\"example-9\"><a href=\"#example-9\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos_five = NonZeroI16::new(<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg_five = NonZeroI16::new(-<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(pos_five.overflowing_neg(), (neg_five, <span class=\"bool-val\">false</span>));\n<span class=\"macro\">assert_eq!</span>(min.overflowing_neg(), (min, <span class=\"bool-val\">true</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos_five+=+NonZeroI16::new(5)?;%0Alet+neg_five+=+NonZeroI16::new(-5)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0A%0Aassert_eq!(pos_five.overflowing_neg(),+(neg_five,+false));%0Aassert_eq!(min.overflowing_neg(),+(min,+true));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_neg\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.71.0, const since 1.71.0\">1.71.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.saturating_neg\" class=\"fn\">saturating_neg</a>(self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class=\"docblock\"><p>Saturating negation. Computes <code>-self</code>,\nreturning <a href=\"core/num/struct.NonZeroI16.html#associatedconstant.MAX\" title=\"associated constant core::num::NonZeroI16::MAX\"><code>NonZeroI16::MAX</code></a>\nif <code>self == NonZeroI16::MIN</code>\ninstead of overflowing.</p>\n<h5 id=\"example-10\"><a href=\"#example-10\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos_five = NonZeroI16::new(<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg_five = NonZeroI16::new(-<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min_plus_one = NonZeroI16::new(i16::MIN + <span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroI16::new(i16::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(pos_five.saturating_neg(), neg_five);\n<span class=\"macro\">assert_eq!</span>(min.saturating_neg(), max);\n<span class=\"macro\">assert_eq!</span>(max.saturating_neg(), min_plus_one);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos_five+=+NonZeroI16::new(5)?;%0Alet+neg_five+=+NonZeroI16::new(-5)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0Alet+min_plus_one+=+NonZeroI16::new(i16::MIN+%2B+1)?;%0Alet+max+=+NonZeroI16::new(i16::MAX)?;%0A%0Aassert_eq!(pos_five.saturating_neg(),+neg_five);%0Aassert_eq!(min.saturating_neg(),+max);%0Aassert_eq!(max.saturating_neg(),+min_plus_one);%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.wrapping_neg\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.71.0, const since 1.71.0\">1.71.0 (const: 1.71.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.wrapping_neg\" class=\"fn\">wrapping_neg</a>(self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class=\"docblock\"><p>Wrapping (modular) negation. Computes <code>-self</code>, wrapping around at the boundary\nof the type.</p>\n<p>See <a href=\"core/primitive.i16.html#method.wrapping_neg\" title=\"method i16::wrapping_neg\"><code>i16::wrapping_neg</code></a>\nfor documentation on overflow behaviour.</p>\n<h5 id=\"example-11\"><a href=\"#example-11\">Example</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>pos_five = NonZeroI16::new(<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>neg_five = NonZeroI16::new(-<span class=\"number\">5</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>min = NonZeroI16::new(i16::MIN)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(pos_five.wrapping_neg(), neg_five);\n<span class=\"macro\">assert_eq!</span>(min.wrapping_neg(), min);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+pos_five+=+NonZeroI16::new(5)?;%0Alet+neg_five+=+NonZeroI16::new(-5)?;%0Alet+min+=+NonZeroI16::new(i16::MIN)?;%0A%0Aassert_eq!(pos_five.wrapping_neg(),+neg_five);%0Aassert_eq!(min.wrapping_neg(),+min);%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroI16\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1171-1184\">source</a><a href=\"#impl-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_mul\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1171-1184\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.checked_mul\" class=\"fn\">checked_mul</a>(self, other: <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Multiplies two non-zero integers together.\nChecks for overflow and returns <a href=\"core/option/enum.Option.html#variant.None\" title=\"variant core::option::Option::None\"><code>None</code></a> on overflow.\nAs a consequence, the result cannot wrap to zero.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>two = NonZeroI16::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroI16::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroI16::new(i16::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(four), two.checked_mul(two));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">None</span>, max.checked_mul(two));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+two+=+NonZeroI16::new(2)?;%0Alet+four+=+NonZeroI16::new(4)?;%0Alet+max+=+NonZeroI16::new(i16::MAX)?;%0A%0Aassert_eq!(Some(four),+two.checked_mul(two));%0Aassert_eq!(None,+max.checked_mul(two));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_mul\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1171-1184\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.saturating_mul\" class=\"fn\">saturating_mul</a>(self, other: <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class=\"docblock\"><p>Multiplies two non-zero integers together.\nReturn <a href=\"core/num/struct.NonZeroI16.html#associatedconstant.MAX\" title=\"associated constant core::num::NonZeroI16::MAX\"><code>NonZeroI16::MAX</code></a> on overflow.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>two = NonZeroI16::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroI16::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroI16::new(i16::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(four, two.saturating_mul(two));\n<span class=\"macro\">assert_eq!</span>(max, four.saturating_mul(max));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+two+=+NonZeroI16::new(2)?;%0Alet+four+=+NonZeroI16::new(4)?;%0Alet+max+=+NonZeroI16::new(i16::MAX)?;%0A%0Aassert_eq!(four,+two.saturating_mul(two));%0Aassert_eq!(max,+four.saturating_mul(max));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.unchecked_mul\" class=\"method\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1171-1184\">source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.unchecked_mul\" class=\"fn\">unchecked_mul</a>(self, other: <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>nonzero_ops</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/84186\">#84186</a>)</span></div></span></summary><div class=\"docblock\"><p>Multiplies two non-zero integers together,\nassuming overflow cannot occur.\nOverflow is unchecked, and it is undefined behaviour to overflow\n<em>even if the result would wrap to a non-zero value</em>.\nThe behaviour is undefined as soon as\n<code>self * rhs &gt; i16::MAX</code>, or <code>self * rhs &lt; i16::MIN</code>.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(nonzero_ops)]\n\n</span><span class=\"kw\">let </span>two = NonZeroI16::new(<span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>four = NonZeroI16::new(<span class=\"number\">4</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(four, <span class=\"kw\">unsafe </span>{ two.unchecked_mul(two) });</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(nonzero_ops)%5D%0A%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+two+=+NonZeroI16::new(2)?;%0Alet+four+=+NonZeroI16::new(4)?;%0A%0Aassert_eq!(four,+unsafe+%7B+two.unchecked_mul(two)+%7D);%0ASome(())%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.checked_pow\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1171-1184\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.checked_pow\" class=\"fn\">checked_pow</a>(self, other: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Raises non-zero value to an integer power.\nChecks for overflow and returns <a href=\"core/option/enum.Option.html#variant.None\" title=\"variant core::option::Option::None\"><code>None</code></a> on overflow.\nAs a consequence, the result cannot wrap to zero.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>three = NonZeroI16::new(<span class=\"number\">3</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>twenty_seven = NonZeroI16::new(<span class=\"number\">27</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>half_max = NonZeroI16::new(i16::MAX / <span class=\"number\">2</span>)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">Some</span>(twenty_seven), three.checked_pow(<span class=\"number\">3</span>));\n<span class=\"macro\">assert_eq!</span>(<span class=\"prelude-val\">None</span>, half_max.checked_pow(<span class=\"number\">3</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+three+=+NonZeroI16::new(3)?;%0Alet+twenty_seven+=+NonZeroI16::new(27)?;%0Alet+half_max+=+NonZeroI16::new(i16::MAX+/+2)?;%0A%0Aassert_eq!(Some(twenty_seven),+three.checked_pow(3));%0Aassert_eq!(None,+half_max.checked_pow(3));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.saturating_pow\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.64.0, const since 1.64.0\">1.64.0 (const: 1.64.0)</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1171-1184\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"core/num/struct.NonZeroI16.html#tymethod.saturating_pow\" class=\"fn\">saturating_pow</a>(self, other: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a>) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class=\"docblock\"><p>Raise non-zero value to an integer power.\nReturn <a href=\"core/num/struct.NonZeroI16.html#associatedconstant.MIN\" title=\"associated constant core::num::NonZeroI16::MIN\"><code>NonZeroI16::MIN</code></a> or <a href=\"core/num/struct.NonZeroI16.html#associatedconstant.MAX\" title=\"associated constant core::num::NonZeroI16::MAX\"><code>NonZeroI16::MAX</code></a> on overflow.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>three = NonZeroI16::new(<span class=\"number\">3</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>twenty_seven = NonZeroI16::new(<span class=\"number\">27</span>)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>max = NonZeroI16::new(i16::MAX)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert_eq!</span>(twenty_seven, three.saturating_pow(<span class=\"number\">3</span>));\n<span class=\"macro\">assert_eq!</span>(max, max.saturating_pow(<span class=\"number\">3</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::num::NonZeroI16;%0Afn+main()+%7B+test().unwrap();+%7D%0Afn+test()+-%3E+Option%3C()%3E+%7B%0Alet+three+=+NonZeroI16::new(3)?;%0Alet+twenty_seven+=+NonZeroI16::new(27)?;%0Alet+max+=+NonZeroI16::new(i16::MAX)?;%0A%0Aassert_eq!(twenty_seven,+three.saturating_pow(3));%0Aassert_eq!(max,+max.saturating_pow(3));%0ASome(())%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroI16\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1310-1317\">source</a><a href=\"#impl-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.MIN\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1310-1317\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/num/struct.NonZeroI16.html#associatedconstant.MIN\" class=\"constant\">MIN</a>: Self = _</h4></section></summary><div class=\"docblock\"><p>The smallest value that can be represented by this non-zero\ninteger type,\nequal to <a href=\"core/primitive.i16.html#associatedconstant.MIN\" title=\"associated constant i16::MIN\"><code>i16::MIN</code></a>.</p>\n<p>Note: While most integer types are defined for every whole\nnumber between <code>MIN</code> and <code>MAX</code>, signed non-zero integers are\na special case. They have a “gap” at 0.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(NonZeroI16::MIN.get(), i16::MIN);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroI16;%0Aassert_eq!(NonZeroI16::MIN.get(),+i16::MIN);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedconstant.MAX\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.70.0\">1.70.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1310-1317\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/num/struct.NonZeroI16.html#associatedconstant.MAX\" class=\"constant\">MAX</a>: Self = _</h4></section></summary><div class=\"docblock\"><p>The largest value that can be represented by this non-zero\ninteger type,\nequal to <a href=\"core/primitive.i16.html#associatedconstant.MAX\" title=\"associated constant i16::MAX\"><code>i16::MAX</code></a>.</p>\n<p>Note: While most integer types are defined for every whole\nnumber between <code>MIN</code> and <code>MAX</code>, signed non-zero integers are\na special case. They have a “gap” at 0.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(NonZeroI16::MAX.get(), i16::MAX);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroI16;%0Aassert_eq!(NonZeroI16::MAX.get(),+i16::MAX);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-NonZeroI16\" class=\"impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#1341-1354\">source</a><a href=\"#impl-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedconstant.BITS\" class=\"associatedconstant\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.67.0\">1.67.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#1341-1354\">source</a></span><h4 class=\"code-header\">pub const <a href=\"core/num/struct.NonZeroI16.html#associatedconstant.BITS\" class=\"constant\">BITS</a>: <a class=\"primitive\" href=\"primitive.u32.html\">u32</a> = 16u32</h4></section></summary><div class=\"docblock\"><p>The size of this non-zero integer type in bits.</p>\n<p>This value is equal to <a href=\"core/primitive.i16.html#associatedconstant.BITS\" title=\"associated constant i16::BITS\"><code>i16::BITS</code></a>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code>\n<span class=\"macro\">assert_eq!</span>(NonZeroI16::BITS, i16::BITS);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::num::NonZeroI16;%0A%0Aassert_eq!(NonZeroI16::BITS,+i16::BITS);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Clone-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"core/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/clone.rs.html#169-171\">source</a></span><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, source: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Self</a>)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"core/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromStr-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.35.0\">1.35.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#209-210\">source</a></span><a href=\"#impl-FromStr-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/str/trait.FromStr.html\" title=\"trait core::str::FromStr\">FromStr</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Err\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Err\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/str/trait.FromStr.html#associatedtype.Err\" class=\"associatedtype\">Err</a> = <a class=\"struct\" href=\"core/num/struct.ParseIntError.html\" title=\"struct core::num::ParseIntError\">ParseIntError</a></h4></section></summary><div class='docblock'>The associated error which can be returned from parsing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_str\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#209-210\">source</a><a href=\"#method.from_str\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/str/trait.FromStr.html#tymethod.from_str\" class=\"fn\">from_str</a>(src: &amp;<a class=\"primitive\" href=\"primitive.str.html\">str</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/str/trait.FromStr.html#associatedtype.Err\" title=\"type core::str::FromStr::Err\">Err</a>&gt;</h4></section></summary><div class='docblock'>Parses a string <code>s</code> to return a value of this type. <a href=\"core/str/trait.FromStr.html#tymethod.from_str\">Read more</a></div></details></div></details>","FromStr","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI128%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI128%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI128.html\" title=\"struct core::num::NonZeroI128\">NonZeroI128</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI128.html\" title=\"struct core::num::NonZeroI128\">NonZeroI128</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI128</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI128>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-UpperHex-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-UpperHex-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.UpperHex.html\" title=\"trait core::fmt::UpperHex\">UpperHex</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.UpperHex.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","UpperHex","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Ord-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.Ord.html\" title=\"trait core::cmp::Ord\">Ord</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>) -&gt; <a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"core/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#826-831\">source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"core/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#846-851\">source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"core/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#871-884\">source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a>,</span></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"core/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-PartialOrd-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.PartialOrd.html\" title=\"trait core::cmp::PartialOrd\">PartialOrd</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"core/cmp/enum.Ordering.html\" title=\"enum core::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"core/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1122-1124\">source</a></span><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1139-1141\">source</a></span><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1155-1157\">source</a></span><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"core/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#1172-1174\">source</a></span><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"core/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Neg-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.71.0\">1.71.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a></span><a href=\"#impl-Neg-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.Neg.html\" title=\"trait core::ops::Neg\">Neg</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.Neg.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>-</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.neg\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#962-969\">source</a><a href=\"#method.neg\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.Neg.html#tymethod.neg\" class=\"fn\">neg</a>(self) -&gt; <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class='docblock'>Performs the unary <code>-</code> operation. <a href=\"core/ops/trait.Neg.html#tymethod.neg\">Read more</a></div></details></div></details>","Neg","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU64%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU64%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU64.html\" title=\"struct core::num::NonZeroU64\">NonZeroU64</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU64.html\" title=\"struct core::num::NonZeroU64\">NonZeroU64</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU64</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU64>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroUsize%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroUsize%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroUsize.html\" title=\"struct core::num::NonZeroUsize\">NonZeroUsize</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroUsize.html\" title=\"struct core::num::NonZeroUsize\">NonZeroUsize</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroUsize</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroUsize>","core::ffi::NonZero_c_short"],["<section id=\"impl-StructuralPartialEq-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-StructuralPartialEq-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/marker/trait.StructuralPartialEq.html\" title=\"trait core::marker::StructuralPartialEq\">StructuralPartialEq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section>","StructuralPartialEq","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Binary-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Binary-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Binary.html\" title=\"trait core::fmt::Binary\">Binary</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Binary.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","Binary","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU32%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU32%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU32.html\" title=\"struct core::num::NonZeroU32\">NonZeroU32</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU32.html\" title=\"struct core::num::NonZeroU32\">NonZeroU32</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU32</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU32>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU16%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU16%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU16.html\" title=\"struct core::num::NonZeroU16\">NonZeroU16</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU16.html\" title=\"struct core::num::NonZeroU16\">NonZeroU16</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU16</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU16>","core::ffi::NonZero_c_short"],["<section id=\"impl-Copy-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Copy-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/marker/trait.Copy.html\" title=\"trait core::marker::Copy\">Copy</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section>","Copy","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CNonZeroI8%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0\">1.41.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#467\">source</a></span><a href=\"#impl-From%3CNonZeroI8%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI8.html\" title=\"struct core::num::NonZeroI8\">NonZeroI8</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#467\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"struct\" href=\"core/num/struct.NonZeroI8.html\" title=\"struct core::num::NonZeroI8\">NonZeroI8</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>NonZeroI8</code> to <code>NonZeroI16</code> losslessly.</p>\n</div></details></div></details>","From<NonZeroI8>","core::ffi::NonZero_c_short"],["<section id=\"impl-StructuralEq-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-StructuralEq-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/marker/trait.StructuralEq.html\" title=\"trait core::marker::StructuralEq\">StructuralEq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section>","StructuralEq","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CNonZeroU8%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.41.0\">1.41.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#481\">source</a></span><a href=\"#impl-From%3CNonZeroU8%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#481\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(small: <a class=\"struct\" href=\"core/num/struct.NonZeroU8.html\" title=\"struct core::num::NonZeroU8\">NonZeroU8</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Converts <code>NonZeroU8</code> to <code>NonZeroI16</code> losslessly.</p>\n</div></details></div></details>","From<NonZeroU8>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI64%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI64%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI64.html\" title=\"struct core::num::NonZeroI64\">NonZeroI64</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI64.html\" title=\"struct core::num::NonZeroI64\">NonZeroI64</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI64</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI64>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Display-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Display-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Display.html\" title=\"trait core::fmt::Display\">Display</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Display.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Display.html#tymethod.fmt\">Read more</a></div></details></div></details>","Display","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroI32%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroI32%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroI32.html\" title=\"struct core::num::NonZeroI32\">NonZeroI32</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroI32.html\" title=\"struct core::num::NonZeroI32\">NonZeroI32</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroI32</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroI32>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroU128%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroU128%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroU128.html\" title=\"struct core::num::NonZeroU128\">NonZeroU128</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroU128.html\" title=\"struct core::num::NonZeroU128\">NonZeroU128</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroU128</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroU128>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr%3Ci16%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOr%3Ci16%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOr.html\" title=\"trait core::ops::BitOr\">BitOr</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>) -&gt; Self::<a class=\"associatedtype\" href=\"core/ops/trait.BitOr.html#associatedtype.Output\" title=\"type core::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr<i16>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-LowerHex-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-LowerHex-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.LowerHex.html\" title=\"trait core::fmt::LowerHex\">LowerHex</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.LowerHex.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","LowerHex","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Octal-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Octal-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Octal.html\" title=\"trait core::fmt::Octal\">Octal</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Octal.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter.</div></details></div></details>","Octal","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOrAssign-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOrAssign-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOrAssign.html\" title=\"trait core::ops::BitOrAssign\">BitOrAssign</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\" class=\"fn\">bitor_assign</a>(&amp;mut self, rhs: Self)</h4></section></summary><div class='docblock'>Performs the <code>|=</code> operation. <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\">Read more</a></div></details></div></details>","BitOrAssign","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Debug-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","core::ffi::NonZero_c_short"],["<section id=\"impl-Eq-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Eq-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section>","Eq","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-Hash-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/hash/trait.Hash.html\" title=\"trait core::hash::Hash\">Hash</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;__H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(&amp;self, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut __H</a>)</h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#242-249\">source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H: <a class=\"trait\" href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\">Hasher</a>&gt;(data: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[Self]</a>, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut H</a>)<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"core/hash/trait.Hasher.html\" title=\"trait core::hash::Hasher\"><code>Hasher</code></a>. <a href=\"core/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOr-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOr-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOr.html\" title=\"trait core::ops::BitOr\">BitOr</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/trait.BitOr.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h4></section></summary><div class='docblock'>The resulting type after applying the <code>|</code> operator.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\" class=\"fn\">bitor</a>(self, rhs: Self) -&gt; Self::<a class=\"associatedtype\" href=\"core/ops/trait.BitOr.html#associatedtype.Output\" title=\"type core::ops::BitOr::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the <code>|</code> operation. <a href=\"core/ops/trait.BitOr.html#tymethod.bitor\">Read more</a></div></details></div></details>","BitOr","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BitOrAssign%3Ci16%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.45.0\">1.45.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-BitOrAssign%3Ci16%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/ops/trait.BitOrAssign.html\" title=\"trait core::ops::BitOrAssign\">BitOrAssign</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.bitor_assign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.bitor_assign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\" class=\"fn\">bitor_assign</a>(&amp;mut self, rhs: <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>)</h4></section></summary><div class='docblock'>Performs the <code>|=</code> operation. <a href=\"core/ops/trait.BitOrAssign.html#tymethod.bitor_assign\">Read more</a></div></details></div></details>","BitOrAssign<i16>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3Ci16%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.46.0\">1.46.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#528\">source</a></span><a href=\"#impl-TryFrom%3Ci16%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"primitive\" href=\"primitive.i16.html\">i16</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#528\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"primitive\" href=\"primitive.i16.html\">i16</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>i16</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<i16>","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.34.0\">1.34.0</span> · <a class=\"src\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a></span><a href=\"#impl-PartialEq-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a> for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/num/nonzero.rs.html#179-192\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#239-241\">source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq","core::ffi::NonZero_c_short"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-TryFrom%3CNonZeroIsize%3E-for-NonZeroI16\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.49.0\">1.49.0</span> · <a class=\"src\" href=\"src/core/convert/num.rs.html#576\">source</a></span><a href=\"#impl-TryFrom%3CNonZeroIsize%3E-for-NonZeroI16\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"core/convert/trait.TryFrom.html\" title=\"trait core::convert::TryFrom\">TryFrom</a>&lt;<a class=\"struct\" href=\"core/num/struct.NonZeroIsize.html\" title=\"struct core::num::NonZeroIsize\">NonZeroIsize</a>&gt; for <a class=\"struct\" href=\"core/num/struct.NonZeroI16.html\" title=\"struct core::num::NonZeroI16\">NonZeroI16</a></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/convert/num.rs.html#576\">source</a><a href=\"#method.try_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.TryFrom.html#tymethod.try_from\" class=\"fn\">try_from</a>(value: <a class=\"struct\" href=\"core/num/struct.NonZeroIsize.html\" title=\"struct core::num::NonZeroIsize\">NonZeroIsize</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, Self::<a class=\"associatedtype\" href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" title=\"type core::convert::TryFrom::Error\">Error</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Attempts to convert <code>NonZeroIsize</code> to <code>NonZeroI16</code>.</p>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Error\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Error\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/convert/trait.TryFrom.html#associatedtype.Error\" class=\"associatedtype\">Error</a> = <a class=\"struct\" href=\"core/num/struct.TryFromIntError.html\" title=\"struct core::num::TryFromIntError\">TryFromIntError</a></h4></section></summary><div class='docblock'>The type returned in the event of a conversion error.</div></details></div></details>","TryFrom<NonZeroIsize>","core::ffi::NonZero_c_short"]]
};if (window.register_type_impls) {window.register_type_impls(type_impls);} else {window.pending_type_impls = type_impls;}})()