var tipuesearch = {"pages":[{"title":" ","text":"neural-fortran A parallel neural net microframework. \nRead the paper here . Features Getting started Building with fpm Building with CMake Examples Creating a network Training the network Saving and loading from file MNIST training example Contributing Contributors Related projects Features Dense, fully connected neural networks of arbitrary shape and size Backprop with Mean Square Error cost function Data-based parallelism Several activation functions Support for 32, 64, and 128-bit floating point numbers Getting started Get the code: git clone https://github.com/modern-fortran/neural-fortran cd neural-fortran Dependencies: Fortran 2018-compatible compiler OpenCoarrays (optional, for parallel execution, GFortran only) BLAS, MKL (optional) Building with fpm Building in serial mode fpm build --flag \"-cpp -O3 -ffast-math -fcoarray=single\" Building in parallel mode If you use GFortran and want to run neural-fortran in parallel,\nyou must first install OpenCoarrays .\nOnce installed, use the compiler wrappers caf and cafrun to build and execute\nin parallel, respectively: fpm build --compiler caf --flag \"-cpp -DCAF -O3 -ffast-math\" Testing with fpm fpm test --flag \"-cpp -O3 -ffast-math -fcoarray=single\" For the time being, you need to specify the same compiler flags to fpm test as you did in fpm build so that fpm can figure out to use the same build\nprofile. See Fortran Package Manager for more info on fpm. Building with CMake Building in serial mode mkdir build cd build cmake .. -DSERIAL=1 make Tests and examples will be built in the bin/ directory. Building in parallel mode If you use GFortran and want to run neural-fortran in parallel,\nyou must first install OpenCoarrays .\nOnce installed, use the compiler wrappers caf and cafrun to build and execute\nin parallel, respectively: FC=caf cmake .. make cafrun -n 4 bin/example_mnist # run MNIST example on 4 cores Building with a different compiler If you want to build with a different compiler, such as Intel Fortran,\nspecify FC when issuing cmake : FC=ifort cmake .. Building with BLAS or MKL To use an external BLAS or MKL library for matmul calls,\nrun cmake like this: cmake .. -DBLAS=-lblas where the value of -DBLAS should point to the desired BLAS implementation,\nwhich has to be available in the linking path.\nThis option is currently available only with gfortran. Building in double or quad precision By default, neural-fortran is built in single precision mode\n(32-bit floating point numbers). Alternatively, you can configure to build\nin 64 or 128-bit floating point mode: cmake .. -DREAL=64 or cmake .. -DREAL=128 Building in debug mode To build with debugging flags enabled, type: cmake .. -DCMAKE_BUILD_TYPE=debug Running tests with CMake Before running the tests, link the the data/ directory to the current directory: ln -s ../data The MNIST dataset which comes with the code as a tarball must be unpacked first.\nSee MNIST training example on how to do that.\nOnce the MNIST dataset is unpacked and the data/ directory is linked in your\nCMake build/ directory, run ctest to run the tests. Examples Creating a network Creating a network with 3 layers,\none input, one hidden, and one output layer,\nwith 3, 5, and 2 neurons each: use mod_network , only : network_type type ( network_type ) :: net net = network_type ([ 3 , 5 , 2 ]) Setting the activation function By default, the network will be initialized with the sigmoid activation\nfunction for all layers. You can specify a different activation function: net = network_type ([ 3 , 5 , 2 ], activation = 'tanh' ) or set it after the fact: net = network_type ([ 3 , 5 , 2 ]) call net % set_activation ( 'tanh' ) It's possible to set different activation functions for each layer.\nFor example, this snippet will create a network with a Gaussian\nactivation functions for all layers except the output layer,\nand a RELU function for the output layer: net = network_type ([ 3 , 5 , 2 ], activation = 'gaussian' ) call net % layers ( 3 ) % set_activation ( 'relu' ) Available activation function options are: gaussian , relu , sigmoid , step , and tanh .\nSee mod_activation.f90 for specifics. Training the network To train the network, pass the training input and output data sample,\nand a learning rate, to net % train() : program example_simple use mod_network , only : network_type implicit none type ( network_type ) :: net real , allocatable :: input (:), output (:) integer :: i net = network_type ([ 3 , 5 , 2 ]) input = [ 0.2 , 0.4 , 0.6 ] output = [ 0.123456 , 0.246802 ] do i = 1 , 500 call net % train ( input , output , eta = 1.0 ) print * , 'Iteration: ' , i , 'Output:' , net % output ( input ) end do end program example_simple The size of input and output arrays must match the sizes of the\ninput and output layers, respectively. The learning rate eta determines\nhow quickly are weights and biases updated. The output is: Iteration:            1 Output:  0.470592350      0.764851630 Iteration:            2 Output:  0.409876496      0.713752568 Iteration:            3 Output:  0.362703383      0.654729187 ... Iteration:          500 Output:  0.123456128      0.246801868 The initial values will vary between runs because we initialize weights\nand biases randomly. Saving and loading from file To save a network to a file, do: call net % save ( 'my_net.txt' ) Loading from file works the same way: call net % load ( 'my_net.txt' ) Synchronizing networks in parallel mode When running in parallel mode, you may need to synchronize the weights\nand biases between images. You can do it like this: call net % sync ( 1 ) The argument to net % sync() refers to the source image from which to\nbroadcast. It can be any positive number not greater than num_images() . MNIST training example The MNIST data is included with the repo and you will have to unpack it first: cd data/mnist tar xzvf mnist.tar.gz cd - The complete program: program example_mnist ! A training example with the MNIST dataset. ! Uses stochastic gradient descent and mini-batch size of 100. ! Can be run in serial or parallel mode without modifications. use mod_kinds , only : ik , rk use mod_mnist , only : label_digits , load_mnist use mod_network , only : network_type implicit none real ( rk ), allocatable :: tr_images (:,:), tr_labels (:) real ( rk ), allocatable :: te_images (:,:), te_labels (:) real ( rk ), allocatable :: input (:,:), output (:,:) type ( network_type ) :: net integer ( ik ) :: i , n , num_epochs integer ( ik ) :: batch_size , batch_start , batch_end real ( rk ) :: pos call load_mnist ( tr_images , tr_labels , te_images , te_labels ) net = network_type ([ 784 , 30 , 10 ]) batch_size = 100 num_epochs = 10 if ( this_image () == 1 ) print '(a,f5.2,a)' , 'Initial accuracy: ' , & net % accuracy ( te_images , label_digits ( te_labels )) * 100 , ' %' epochs : do n = 1 , num_epochs batches : do i = 1 , size ( tr_labels ) / batch_size ! pull a random mini-batch from the dataset call random_number ( pos ) batch_start = int ( pos * ( size ( tr_labels ) - batch_size + 1 )) batch_end = batch_start + batch_size - 1 ! prepare mini-batch input = tr_images (:, batch_start : batch_end ) output = label_digits ( tr_labels ( batch_start : batch_end )) ! train the network on the mini-batch call net % train ( input , output , eta = 3._rk ) end do batches if ( this_image () == 1 ) print '(a,i2,a,f5.2,a)' , 'Epoch ' , n , ' done, Accuracy: ' , & net % accuracy ( te_images , label_digits ( te_labels )) * 100 , ' %' end do epochs end program example_mnist The program will report the accuracy after each epoch: $ ./example_mnist\nInitial accuracy: 10 .32 %\nEpoch 1 done , Accuracy: 91 .06 %\nEpoch 2 done , Accuracy: 92 .35 %\nEpoch 3 done , Accuracy: 93 .32 %\nEpoch 4 done , Accuracy: 93 .62 %\nEpoch 5 done , Accuracy: 93 .97 %\nEpoch 6 done , Accuracy: 94 .16 %\nEpoch 7 done , Accuracy: 94 .42 %\nEpoch 8 done , Accuracy: 94 .55 %\nEpoch 9 done , Accuracy: 94 .67 %\nEpoch 10 done , Accuracy: 94 .81 % You can also run this example without any modifications in parallel,\nfor example on 16 cores using OpenCoarrays : $ cafrun -n 16 ./example_mnist Contributing neural-fortran is currently a proof-of-concept with potential for\nuse in production. Contributions are welcome, especially for: Expanding the network class to other network infrastructures Adding other cost functions such as cross-entropy. Model-based ( matmul ) parallelism Adding more examples Others? You can start at the list of open issues . Contributors Thanks to all open-source contributors to neural-fortran: @ivan-pi @jvdp1 @milancurcic @pirpyn @rouson @scivision Related projects Fortran Keras Bridge (FKB) rte-rrtmgp Developer Info Milan Curcic","tags":"home","loc":"index.html"},{"title":"mod_parallel.f90 – ","text":"This file depends on sourcefile~~mod_parallel.f90~~EfferentGraph sourcefile~mod_parallel.f90 mod_parallel.f90 sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_parallel.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Files dependent on this one sourcefile~~mod_parallel.f90~~AfferentGraph sourcefile~mod_parallel.f90 mod_parallel.f90 sourcefile~mod_network.f90 mod_network.f90 sourcefile~mod_network.f90->sourcefile~mod_parallel.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_parallel Source Code mod_parallel.f90 Source Code module mod_parallel use mod_kinds , only : ik , rk implicit none private public :: tile_indices contains pure function tile_indices ( dims ) !! Given input global array size, return start and end index !! of a parallel 1-d tile that correspond to this image. integer ( ik ), intent ( in ) :: dims integer ( ik ) :: tile_indices ( 2 ) integer ( ik ) :: offset , tile_size tile_size = dims / num_images () !! start and end indices assuming equal tile sizes tile_indices ( 1 ) = ( this_image () - 1 ) * tile_size + 1 tile_indices ( 2 ) = tile_indices ( 1 ) + tile_size - 1 !! if we have any remainder, distribute it to the tiles at the end offset = num_images () - mod ( dims , num_images ()) if ( this_image () > offset ) then tile_indices ( 1 ) = tile_indices ( 1 ) + this_image () - offset - 1 tile_indices ( 2 ) = tile_indices ( 2 ) + this_image () - offset end if end function tile_indices end module mod_parallel","tags":"","loc":"sourcefile/mod_parallel.f90.html"},{"title":"mod_layer.f90 – ","text":"This file depends on sourcefile~~mod_layer.f90~~EfferentGraph sourcefile~mod_layer.f90 mod_layer.f90 sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_layer.f90->sourcefile~mod_kinds.f90 sourcefile~mod_random.f90 mod_random.f90 sourcefile~mod_layer.f90->sourcefile~mod_random.f90 sourcefile~mod_activation.f90 mod_activation.f90 sourcefile~mod_layer.f90->sourcefile~mod_activation.f90 sourcefile~mod_random.f90->sourcefile~mod_kinds.f90 sourcefile~mod_activation.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Files dependent on this one sourcefile~~mod_layer.f90~~AfferentGraph sourcefile~mod_layer.f90 mod_layer.f90 sourcefile~mod_network.f90 mod_network.f90 sourcefile~mod_network.f90->sourcefile~mod_layer.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_layer Source Code mod_layer.f90 Source Code module mod_layer !! Defines the layer type and its methods. use mod_activation use mod_kinds , only : ik , rk use mod_random , only : randn implicit none private public :: array1d , array2d , db_init , db_co_sum , dw_init , dw_co_sum , layer_type type :: layer_type real ( rk ), allocatable :: a (:) !! activations real ( rk ), allocatable :: b (:) !! biases real ( rk ), allocatable :: w (:,:) !! weights real ( rk ), allocatable :: z (:) !! arg. to activation function procedure ( activation_function ), pointer , nopass :: activation => null () procedure ( activation_function ), pointer , nopass :: activation_prime => null () character ( len = :), allocatable :: activation_str !! activation character string contains procedure , public , pass ( self ) :: set_activation end type layer_type type :: array1d real ( rk ), allocatable :: array (:) end type array1d type :: array2d real ( rk ), allocatable :: array (:,:) end type array2d interface layer_type module procedure :: constructor end interface layer_type interface array1d module procedure :: array1d_constructor end interface array1d interface array2d module procedure :: array2d_constructor end interface array2d contains type ( layer_type ) function constructor ( this_size , next_size ) result ( layer ) !! Layer class constructor. this_size is the number of neurons in the layer. !! next_size is the number of neurons in the next layer, used to allocate !! the weights. integer ( ik ), intent ( in ) :: this_size , next_size allocate ( layer % a ( this_size )) allocate ( layer % z ( this_size )) layer % a = 0 layer % z = 0 layer % w = randn ( this_size , next_size ) / this_size layer % b = randn ( this_size ) end function constructor pure type ( array1d ) function array1d_constructor ( length ) result ( a ) !! Overloads the default type constructor. integer ( ik ), intent ( in ) :: length allocate ( a % array ( length )) a % array = 0 end function array1d_constructor pure type ( array2d ) function array2d_constructor ( dims ) result ( a ) !! Overloads the default type constructor. integer ( ik ), intent ( in ) :: dims ( 2 ) allocate ( a % array ( dims ( 1 ), dims ( 2 ))) a % array = 0 end function array2d_constructor pure subroutine db_init ( db , dims ) !! Initialises biases structure. type ( array1d ), allocatable , intent ( in out ) :: db (:) integer ( ik ), intent ( in ) :: dims (:) integer ( ik ) :: n , nm nm = size ( dims ) allocate ( db ( nm )) do n = 1 , nm - 1 db ( n ) = array1d ( dims ( n )) end do db ( n ) = array1d ( dims ( n )) end subroutine db_init pure subroutine dw_init ( dw , dims ) !! Initialises weights structure. type ( array2d ), allocatable , intent ( in out ) :: dw (:) integer ( ik ), intent ( in ) :: dims (:) integer ( ik ) :: n , nm nm = size ( dims ) allocate ( dw ( nm )) do n = 1 , nm - 1 dw ( n ) = array2d ( dims ( n : n + 1 )) end do dw ( n ) = array2d ([ dims ( n ), 1 ]) end subroutine dw_init subroutine db_co_sum ( db ) !! Performs a collective sum of bias tendencies. type ( array1d ), allocatable , intent ( in out ) :: db (:) integer ( ik ) :: n do n = 2 , size ( db ) #ifdef CAF call co_sum ( db ( n ) % array ) #endif end do end subroutine db_co_sum subroutine dw_co_sum ( dw ) !! Performs a collective sum of weights tendencies. type ( array2d ), allocatable , intent ( in out ) :: dw (:) integer ( ik ) :: n do n = 1 , size ( dw ) - 1 #ifdef CAF call co_sum ( dw ( n ) % array ) #endif end do end subroutine dw_co_sum pure elemental subroutine set_activation ( self , activation ) !! Sets the activation function. Input string must match one of !! provided activation functions, otherwise it defaults to sigmoid. !! If activation not present, defaults to sigmoid. class ( layer_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: activation select case ( trim ( activation )) case ( 'gaussian' ) self % activation => gaussian self % activation_prime => gaussian_prime self % activation_str = 'gaussian' case ( 'relu' ) self % activation => relu self % activation_prime => relu_prime self % activation_str = 'relu' case ( 'sigmoid' ) self % activation => sigmoid self % activation_prime => sigmoid_prime self % activation_str = 'sigmoid' case ( 'step' ) self % activation => step self % activation_prime => step_prime self % activation_str = 'step' case ( 'tanh' ) self % activation => tanhf self % activation_prime => tanh_prime self % activation_str = 'tanh' case default self % activation => sigmoid self % activation_prime => sigmoid_prime self % activation_str = 'sigmoid' end select end subroutine set_activation end module mod_layer","tags":"","loc":"sourcefile/mod_layer.f90.html"},{"title":"mod_kinds.f90 – ","text":"Files dependent on this one sourcefile~~mod_kinds.f90~~AfferentGraph sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_layer.f90 mod_layer.f90 sourcefile~mod_layer.f90->sourcefile~mod_kinds.f90 sourcefile~mod_activation.f90 mod_activation.f90 sourcefile~mod_layer.f90->sourcefile~mod_activation.f90 sourcefile~mod_random.f90 mod_random.f90 sourcefile~mod_layer.f90->sourcefile~mod_random.f90 sourcefile~mod_parallel.f90 mod_parallel.f90 sourcefile~mod_parallel.f90->sourcefile~mod_kinds.f90 sourcefile~mod_network.f90 mod_network.f90 sourcefile~mod_network.f90->sourcefile~mod_kinds.f90 sourcefile~mod_network.f90->sourcefile~mod_layer.f90 sourcefile~mod_network.f90->sourcefile~mod_parallel.f90 sourcefile~mod_mnist.f90 mod_mnist.f90 sourcefile~mod_mnist.f90->sourcefile~mod_kinds.f90 sourcefile~mod_io.f90 mod_io.f90 sourcefile~mod_mnist.f90->sourcefile~mod_io.f90 sourcefile~mod_activation.f90->sourcefile~mod_kinds.f90 sourcefile~mod_random.f90->sourcefile~mod_kinds.f90 sourcefile~mod_io.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_kinds Source Code mod_kinds.f90 Source Code module mod_kinds use iso_fortran_env , only : int32 , int64 , real32 , real64 , real128 implicit none private public :: ik , rk #ifdef REAL64 integer , parameter :: rk = real64 #elif REAL128 integer , parameter :: rk = real128 #else integer , parameter :: rk = real32 #endif #ifdef INT64 integer , parameter :: ik = int64 #else integer , parameter :: ik = int32 #endif end module mod_kinds","tags":"","loc":"sourcefile/mod_kinds.f90.html"},{"title":"mod_random.f90 – ","text":"This file depends on sourcefile~~mod_random.f90~~EfferentGraph sourcefile~mod_random.f90 mod_random.f90 sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_random.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Files dependent on this one sourcefile~~mod_random.f90~~AfferentGraph sourcefile~mod_random.f90 mod_random.f90 sourcefile~mod_layer.f90 mod_layer.f90 sourcefile~mod_layer.f90->sourcefile~mod_random.f90 sourcefile~mod_network.f90 mod_network.f90 sourcefile~mod_network.f90->sourcefile~mod_layer.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_random Source Code mod_random.f90 Source Code module mod_random !! Provides a random number generator with !! normal distribution, centered on zero. use mod_kinds , only : ik , rk implicit none private public :: randn real ( rk ), parameter :: pi = 4 * atan ( 1._rk ) interface randn module procedure :: randn1d , randn2d end interface randn contains function randn1d ( n ) result ( r ) !! Generates n random numbers with a normal distribution. integer ( ik ), intent ( in ) :: n real ( rk ) :: r ( n ), r2 ( n ) call random_number ( r ) call random_number ( r2 ) r = sqrt ( - 2 * log ( r )) * cos ( 2 * pi * r2 ) end function randn1d function randn2d ( m , n ) result ( r ) !! Generates m x n random numbers with a normal distribution. integer ( ik ), intent ( in ) :: m , n real ( rk ) :: r ( m , n ), r2 ( m , n ) call random_number ( r ) call random_number ( r2 ) r = sqrt ( - 2 * log ( r )) * cos ( 2 * pi * r2 ) end function randn2d end module mod_random","tags":"","loc":"sourcefile/mod_random.f90.html"},{"title":"mod_network.f90 – ","text":"This file depends on sourcefile~~mod_network.f90~~EfferentGraph sourcefile~mod_network.f90 mod_network.f90 sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_network.f90->sourcefile~mod_kinds.f90 sourcefile~mod_layer.f90 mod_layer.f90 sourcefile~mod_network.f90->sourcefile~mod_layer.f90 sourcefile~mod_parallel.f90 mod_parallel.f90 sourcefile~mod_network.f90->sourcefile~mod_parallel.f90 sourcefile~mod_layer.f90->sourcefile~mod_kinds.f90 sourcefile~mod_activation.f90 mod_activation.f90 sourcefile~mod_layer.f90->sourcefile~mod_activation.f90 sourcefile~mod_random.f90 mod_random.f90 sourcefile~mod_layer.f90->sourcefile~mod_random.f90 sourcefile~mod_parallel.f90->sourcefile~mod_kinds.f90 sourcefile~mod_activation.f90->sourcefile~mod_kinds.f90 sourcefile~mod_random.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_network Source Code mod_network.f90 Source Code module mod_network use mod_kinds , only : ik , rk use mod_layer , only : array1d , array2d , db_init , dw_init ,& db_co_sum , dw_co_sum , layer_type use mod_parallel , only : tile_indices implicit none private public :: network_type type :: network_type type ( layer_type ), allocatable :: layers (:) integer ( ik ), allocatable :: dims (:) contains procedure , public , pass ( self ) :: accuracy procedure , public , pass ( self ) :: backprop procedure , public , pass ( self ) :: fwdprop procedure , public , pass ( self ) :: init procedure , public , pass ( self ) :: load procedure , public , pass ( self ) :: loss procedure , public , pass ( self ) :: output_batch procedure , public , pass ( self ) :: output_single procedure , public , pass ( self ) :: save procedure , public , pass ( self ) :: set_activation_equal procedure , public , pass ( self ) :: set_activation_layers procedure , public , pass ( self ) :: sync procedure , public , pass ( self ) :: train_batch procedure , public , pass ( self ) :: train_epochs procedure , public , pass ( self ) :: train_single procedure , public , pass ( self ) :: update generic , public :: output => output_batch , output_single generic , public :: set_activation => set_activation_equal , set_activation_layers generic , public :: train => train_batch , train_epochs , train_single end type network_type interface network_type module procedure :: net_constructor end interface network_type contains type ( network_type ) function net_constructor ( dims , activation ) result ( net ) !! Network class constructor. Size of input array dims indicates the total !! number of layers (input + hidden + output), and the value of its elements !! corresponds the size of each layer. integer ( ik ), intent ( in ) :: dims (:) character ( len =* ), intent ( in ), optional :: activation call net % init ( dims ) if ( present ( activation )) then call net % set_activation ( activation ) else call net % set_activation ( 'sigmoid' ) end if call net % sync ( 1 ) end function net_constructor pure real ( rk ) function accuracy ( self , x , y ) !! Given input x and output y, evaluates the position of the !! maximum value of the output and returns the number of matches !! relative to the size of the dataset. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:,:), y (:,:) integer ( ik ) :: i , good good = 0 do i = 1 , size ( x , dim = 2 ) if ( all ( maxloc ( self % output ( x (:, i ))) == maxloc ( y (:, i )))) then good = good + 1 end if end do accuracy = real ( good , kind = rk ) / size ( x , dim = 2 ) end function accuracy pure subroutine backprop ( self , y , dw , db ) !! Applies a backward propagation through the network !! and returns the weight and bias gradients. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: y (:) type ( array2d ), allocatable , intent ( out ) :: dw (:) type ( array1d ), allocatable , intent ( out ) :: db (:) integer ( ik ) :: n , nm associate ( dims => self % dims , layers => self % layers ) call db_init ( db , dims ) call dw_init ( dw , dims ) n = size ( dims ) db ( n ) % array = ( layers ( n ) % a - y ) * self % layers ( n ) % activation_prime ( layers ( n ) % z ) dw ( n - 1 ) % array = matmul ( reshape ( layers ( n - 1 ) % a , [ dims ( n - 1 ), 1 ]),& reshape ( db ( n ) % array , [ 1 , dims ( n )])) do n = size ( dims ) - 1 , 2 , - 1 db ( n ) % array = matmul ( layers ( n ) % w , db ( n + 1 ) % array )& * self % layers ( n ) % activation_prime ( layers ( n ) % z ) dw ( n - 1 ) % array = matmul ( reshape ( layers ( n - 1 ) % a , [ dims ( n - 1 ), 1 ]),& reshape ( db ( n ) % array , [ 1 , dims ( n )])) end do end associate end subroutine backprop pure subroutine fwdprop ( self , x ) !! Performs the forward propagation and stores arguments to activation !! functions and activations themselves for use in backprop. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: x (:) integer ( ik ) :: n associate ( layers => self % layers ) layers ( 1 ) % a = x do n = 2 , size ( layers ) layers ( n ) % z = matmul ( transpose ( layers ( n - 1 ) % w ), layers ( n - 1 ) % a ) + layers ( n ) % b layers ( n ) % a = self % layers ( n ) % activation ( layers ( n ) % z ) end do end associate end subroutine fwdprop subroutine init ( self , dims ) !! Allocates and initializes the layers with given dimensions dims. class ( network_type ), intent ( in out ) :: self integer ( ik ), intent ( in ) :: dims (:) integer ( ik ) :: n self % dims = dims if (. not . allocated ( self % layers )) allocate ( self % layers ( size ( dims ))) do n = 1 , size ( dims ) - 1 self % layers ( n ) = layer_type ( dims ( n ), dims ( n + 1 )) end do self % layers ( n ) = layer_type ( dims ( n ), 1 ) self % layers ( 1 ) % b = 0 self % layers ( size ( dims )) % w = 0 end subroutine init subroutine load ( self , filename ) !! Loads the network from file. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: filename integer ( ik ) :: fileunit , n , num_layers , layer_idx integer ( ik ), allocatable :: dims (:) character ( len = 100 ) :: buffer !! activation string open ( newunit = fileunit , file = filename , status = 'old' , action = 'read' ) read ( fileunit , * ) num_layers allocate ( dims ( num_layers )) read ( fileunit , * ) dims call self % init ( dims ) do n = 1 , num_layers read ( fileunit , * ) layer_idx , buffer call self % layers ( layer_idx ) % set_activation ( trim ( buffer )) end do do n = 2 , size ( self % dims ) read ( fileunit , * ) self % layers ( n ) % b end do do n = 1 , size ( self % dims ) - 1 read ( fileunit , * ) self % layers ( n ) % w end do close ( fileunit ) end subroutine load pure real ( rk ) function loss ( self , x , y ) !! Given input x and expected output y, returns the loss of the network. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:), y (:) loss = 0.5 * sum (( y - self % output ( x )) ** 2 ) / size ( x ) end function loss pure function output_single ( self , x ) result ( a ) !! Use forward propagation to compute the output of the network. !! This specific procedure is for a single sample of 1-d input data. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:) real ( rk ), allocatable :: a (:) integer ( ik ) :: n associate ( layers => self % layers ) a = self % layers ( 2 ) % activation ( matmul ( transpose ( layers ( 1 ) % w ), x ) + layers ( 2 ) % b ) do n = 3 , size ( layers ) a = self % layers ( n ) % activation ( matmul ( transpose ( layers ( n - 1 ) % w ), a ) + layers ( n ) % b ) end do end associate end function output_single pure function output_batch ( self , x ) result ( a ) !! Use forward propagation to compute the output of the network. !! This specific procedure is for a batch of 1-d input data. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:,:) real ( rk ), allocatable :: a (:,:) integer ( ik ) :: i allocate ( a ( self % dims ( size ( self % dims )), size ( x , dim = 2 ))) do i = 1 , size ( x , dim = 2 ) a (:, i ) = self % output_single ( x (:, i )) end do end function output_batch subroutine save ( self , filename ) !! Saves the network to a file. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: filename integer ( ik ) :: fileunit , n open ( newunit = fileunit , file = filename ) write ( fileunit , fmt =* ) size ( self % dims ) write ( fileunit , fmt =* ) self % dims do n = 1 , size ( self % dims ) write ( fileunit , fmt =* ) n , self % layers ( n ) % activation_str end do do n = 2 , size ( self % dims ) write ( fileunit , fmt =* ) self % layers ( n ) % b end do do n = 1 , size ( self % dims ) - 1 write ( fileunit , fmt =* ) self % layers ( n ) % w end do close ( fileunit ) end subroutine save pure subroutine set_activation_equal ( self , activation ) !! A thin wrapper around layer % set_activation(). !! This method can be used to set an activation function !! for all layers at once. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: activation call self % layers (:) % set_activation ( activation ) end subroutine set_activation_equal pure subroutine set_activation_layers ( self , activation ) !! A thin wrapper around layer % set_activation(). !! This method can be used to set different activation functions !! for each layer separately. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: activation ( size ( self % layers )) call self % layers (:) % set_activation ( activation ) end subroutine set_activation_layers subroutine sync ( self , image ) !! Broadcasts network weights and biases from !! specified image to all others. class ( network_type ), intent ( in out ) :: self integer ( ik ), intent ( in ) :: image integer ( ik ) :: n if ( num_images () == 1 ) return layers : do n = 1 , size ( self % dims ) #ifdef CAF call co_broadcast ( self % layers ( n ) % b , image ) call co_broadcast ( self % layers ( n ) % w , image ) #endif end do layers end subroutine sync subroutine train_batch ( self , x , y , eta ) !! Trains a network using input data x and output data y, !! and learning rate eta. The learning rate is normalized !! with the size of the data batch. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: x (:,:), y (:,:), eta type ( array1d ), allocatable :: db (:), db_batch (:) type ( array2d ), allocatable :: dw (:), dw_batch (:) integer ( ik ) :: i , im , n , nm integer ( ik ) :: is , ie , indices ( 2 ) im = size ( x , dim = 2 ) !! mini-batch size nm = size ( self % dims ) !! number of layers ! get start and end index for mini-batch indices = tile_indices ( im ) is = indices ( 1 ) ie = indices ( 2 ) call db_init ( db_batch , self % dims ) call dw_init ( dw_batch , self % dims ) do concurrent ( i = is : ie ) call self % fwdprop ( x (:, i )) call self % backprop ( y (:, i ), dw , db ) do concurrent ( n = 1 : nm ) dw_batch ( n ) % array = dw_batch ( n ) % array + dw ( n ) % array db_batch ( n ) % array = db_batch ( n ) % array + db ( n ) % array end do end do if ( num_images () > 1 ) then call dw_co_sum ( dw_batch ) call db_co_sum ( db_batch ) end if call self % update ( dw_batch , db_batch , eta / im ) end subroutine train_batch subroutine train_epochs ( self , x , y , eta , num_epochs , batch_size ) !! Trains for num_epochs epochs with mini-bachtes of size equal to batch_size. class ( network_type ), intent ( in out ) :: self integer ( ik ), intent ( in ) :: num_epochs , batch_size real ( rk ), intent ( in ) :: x (:,:), y (:,:), eta integer ( ik ) :: i , n , nsamples , nbatch integer ( ik ) :: batch_start , batch_end real ( rk ) :: pos nsamples = size ( y , dim = 2 ) nbatch = nsamples / batch_size epochs : do n = 1 , num_epochs batches : do i = 1 , nbatch !pull a random mini-batch from the dataset call random_number ( pos ) batch_start = int ( pos * ( nsamples - batch_size + 1 )) if ( batch_start == 0 ) batch_start = 1 batch_end = batch_start + batch_size - 1 call self % train ( x (:, batch_start : batch_end ), y (:, batch_start : batch_end ), eta ) end do batches end do epochs end subroutine train_epochs pure subroutine train_single ( self , x , y , eta ) !! Trains a network using a single set of input data x and output data y, !! and learning rate eta. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: x (:), y (:), eta type ( array2d ), allocatable :: dw (:) type ( array1d ), allocatable :: db (:) call self % fwdprop ( x ) call self % backprop ( y , dw , db ) call self % update ( dw , db , eta ) end subroutine train_single pure subroutine update ( self , dw , db , eta ) !! Updates network weights and biases with gradients dw and db, !! scaled by learning rate eta. class ( network_type ), intent ( in out ) :: self class ( array2d ), intent ( in ) :: dw (:) class ( array1d ), intent ( in ) :: db (:) real ( rk ), intent ( in ) :: eta integer ( ik ) :: n associate ( layers => self % layers , nm => size ( self % dims )) !! update biases do concurrent ( n = 2 : nm ) layers ( n ) % b = layers ( n ) % b - eta * db ( n ) % array end do !! update weights do concurrent ( n = 1 : nm - 1 ) layers ( n ) % w = layers ( n ) % w - eta * dw ( n ) % array end do end associate end subroutine update end module mod_network","tags":"","loc":"sourcefile/mod_network.f90.html"},{"title":"mod_io.f90 – ","text":"This file depends on sourcefile~~mod_io.f90~~EfferentGraph sourcefile~mod_io.f90 mod_io.f90 sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_io.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Files dependent on this one sourcefile~~mod_io.f90~~AfferentGraph sourcefile~mod_io.f90 mod_io.f90 sourcefile~mod_mnist.f90 mod_mnist.f90 sourcefile~mod_mnist.f90->sourcefile~mod_io.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_io Source Code mod_io.f90 Source Code module mod_io use mod_kinds , only : ik , rk implicit none private public :: read_binary_file interface read_binary_file module procedure :: read_binary_file_1d , read_binary_file_2d end interface read_binary_file contains subroutine read_binary_file_1d ( filename , dtype , nrec , array ) character ( len =* ), intent ( in ) :: filename integer ( ik ), intent ( in ) :: dtype , nrec real ( rk ), allocatable , intent ( in out ) :: array (:) integer ( ik ) :: fileunit allocate ( array ( nrec )) open ( newunit = fileunit , file = filename , access = 'direct' ,& action = 'read' , recl = dtype * nrec , status = 'old' ) read ( fileunit , rec = 1 ) array close ( fileunit ) end subroutine read_binary_file_1d subroutine read_binary_file_2d ( filename , dtype , dsize , nrec , array ) character ( len =* ), intent ( in ) :: filename integer ( ik ), intent ( in ) :: dtype , dsize , nrec real ( rk ), allocatable , intent ( in out ) :: array (:,:) integer ( ik ) :: fileunit , i allocate ( array ( dsize , nrec )) open ( newunit = fileunit , file = filename , access = 'direct' ,& action = 'read' , recl = dtype * dsize , status = 'old' ) do i = 1 , nrec read ( fileunit , rec = i ) array (:, i ) end do close ( fileunit ) end subroutine read_binary_file_2d end module mod_io","tags":"","loc":"sourcefile/mod_io.f90.html"},{"title":"mod_activation.f90 – ","text":"This file depends on sourcefile~~mod_activation.f90~~EfferentGraph sourcefile~mod_activation.f90 mod_activation.f90 sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_activation.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Files dependent on this one sourcefile~~mod_activation.f90~~AfferentGraph sourcefile~mod_activation.f90 mod_activation.f90 sourcefile~mod_layer.f90 mod_layer.f90 sourcefile~mod_layer.f90->sourcefile~mod_activation.f90 sourcefile~mod_network.f90 mod_network.f90 sourcefile~mod_network.f90->sourcefile~mod_layer.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_activation Source Code mod_activation.f90 Source Code module mod_activation !! A collection of activation functions and their derivatives. use mod_kinds , only : ik , rk implicit none private public :: activation_function public :: gaussian , gaussian_prime public :: relu , relu_prime public :: sigmoid , sigmoid_prime public :: step , step_prime public :: tanhf , tanh_prime interface pure function activation_function ( x ) import :: rk real ( rk ), intent ( in ) :: x (:) real ( rk ) :: activation_function ( size ( x )) end function activation_function end interface contains pure function gaussian ( x ) result ( res ) !! Gaussian activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = exp ( - x ** 2 ) end function gaussian pure function gaussian_prime ( x ) result ( res ) !! First derivative of the Gaussian activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = - 2 * x * gaussian ( x ) end function gaussian_prime pure function relu ( x ) result ( res ) !! REctified Linear Unit (RELU) activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = max ( 0. , x ) end function relu pure function relu_prime ( x ) result ( res ) !! First derivative of the REctified Linear Unit (RELU) activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) where ( x > 0 ) res = 1 elsewhere res = 0 end where end function relu_prime pure function sigmoid ( x ) result ( res ) !! Sigmoid activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = 1 / ( 1 + exp ( - x )) endfunction sigmoid pure function sigmoid_prime ( x ) result ( res ) !! First derivative of the sigmoid activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = sigmoid ( x ) * ( 1 - sigmoid ( x )) end function sigmoid_prime pure function step ( x ) result ( res ) !! Step activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) where ( x > 0 ) res = 1 elsewhere res = 0 end where end function step pure function step_prime ( x ) result ( res ) !! First derivative of the step activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = 0 end function step_prime pure function tanhf ( x ) result ( res ) !! Tangent hyperbolic activation function. !! Same as the intrinsic tanh, but must be !! defined here so that we can use procedure !! pointer with it. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = tanh ( x ) end function tanhf pure function tanh_prime ( x ) result ( res ) !! First derivative of the tanh activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = 1 - tanh ( x ) ** 2 end function tanh_prime end module mod_activation","tags":"","loc":"sourcefile/mod_activation.f90.html"},{"title":"mod_mnist.f90 – ","text":"This file depends on sourcefile~~mod_mnist.f90~~EfferentGraph sourcefile~mod_mnist.f90 mod_mnist.f90 sourcefile~mod_kinds.f90 mod_kinds.f90 sourcefile~mod_mnist.f90->sourcefile~mod_kinds.f90 sourcefile~mod_io.f90 mod_io.f90 sourcefile~mod_mnist.f90->sourcefile~mod_io.f90 sourcefile~mod_io.f90->sourcefile~mod_kinds.f90 Help × Graph Key Nodes of different colours represent the following: Graph Key Source File Source File This Page's Entity This Page's Entity Solid arrows point from a file to a file which it depends on. A file\n    is dependent upon another if the latter must be compiled before the former\n    can be. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Modules mod_mnist Source Code mod_mnist.f90 Source Code module mod_mnist !! Procedures to work with MNIST dataset, usable with data format !! as provided in this repo and not the original data format (idx). use iso_fortran_env , only : real32 !! TODO make MNIST work with arbitrary precision use mod_io , only : read_binary_file use mod_kinds , only : ik , rk implicit none private public :: label_digits , load_mnist , print_image contains pure function digits ( x ) !! Returns an array of 10 reals, with zeros everywhere !! and a one corresponding to the input number, for example: !!   digits(0) = [1., 0., 0., 0., 0., 0., 0., 0., 0., 0.] !!   digits(1) = [0., 1., 0., 0., 0., 0., 0., 0., 0., 0.] !!   digits(6) = [0., 0., 0., 0., 0., 0., 1., 0., 0., 0.] real ( rk ), intent ( in ) :: x real ( rk ) :: digits ( 10 ) digits = 0 digits ( int ( x + 1 )) = 1 end function digits pure function label_digits ( labels ) result ( res ) !! Converts an array of MNIST labels into a form !! that can be input to the network_type instance. real ( rk ), intent ( in ) :: labels (:) real ( rk ) :: res ( 10 , size ( labels )) integer ( ik ) :: i do i = 1 , size ( labels ) res (:, i ) = digits ( labels ( i )) end do end function label_digits subroutine load_mnist ( tr_images , tr_labels , te_images ,& te_labels , va_images , va_labels ) !! Loads the MNIST dataset into arrays. real ( rk ), allocatable , intent ( in out ) :: tr_images (:,:), tr_labels (:) real ( rk ), allocatable , intent ( in out ) :: te_images (:,:), te_labels (:) real ( rk ), allocatable , intent ( in out ), optional :: va_images (:,:), va_labels (:) integer ( ik ), parameter :: dtype = 4 , image_size = 784 integer ( ik ), parameter :: tr_nimages = 50000 integer ( ik ), parameter :: te_nimages = 10000 integer ( ik ), parameter :: va_nimages = 10000 call read_binary_file ( 'data/mnist/mnist_training_images.dat' ,& dtype , image_size , tr_nimages , tr_images ) call read_binary_file ( 'data/mnist/mnist_training_labels.dat' ,& dtype , tr_nimages , tr_labels ) call read_binary_file ( 'data/mnist/mnist_testing_images.dat' ,& dtype , image_size , te_nimages , te_images ) call read_binary_file ( 'data/mnist/mnist_testing_labels.dat' ,& dtype , te_nimages , te_labels ) if ( present ( va_images ) . and . present ( va_labels )) then call read_binary_file ( 'data/mnist/mnist_validation_images.dat' ,& dtype , image_size , va_nimages , va_images ) call read_binary_file ( 'data/mnist/mnist_validation_labels.dat' ,& dtype , va_nimages , va_labels ) end if end subroutine load_mnist subroutine print_image ( images , labels , n ) !! Prints a single image and label to screen. real ( rk ), intent ( in ) :: images (:,:), labels (:) integer ( ik ), intent ( in ) :: n real ( rk ) :: image ( 28 , 28 ) character ( len = 1 ) :: char_image ( 28 , 28 ) integer ( ik ) i , j image = reshape ( images (:, n ), [ 28 , 28 ]) char_image = '.' where ( image > 0 ) char_image = '#' print * , labels ( n ) do j = 1 , 28 print * , char_image (:, j ) end do end subroutine print_image end module mod_mnist","tags":"","loc":"sourcefile/mod_mnist.f90.html"},{"title":"array1d –  ","text":"type, public :: array1d Contents Variables array Constructor array1d Source Code array1d Components Type Visibility Attributes Name Initial real(kind=rk), public, allocatable :: array (:) Constructor public interface array1d private pure function array1d_constructor (length) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: length Return Value type( array1d ) Source Code type :: array1d real ( rk ), allocatable :: array (:) end type array1d","tags":"","loc":"type/array1d.html"},{"title":"array2d –  ","text":"type, public :: array2d Contents Variables array Constructor array2d Source Code array2d Components Type Visibility Attributes Name Initial real(kind=rk), public, allocatable :: array (:,:) Constructor public interface array2d private pure function array2d_constructor (dims) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (2) Return Value type( array2d ) Source Code type :: array2d real ( rk ), allocatable :: array (:,:) end type array2d","tags":"","loc":"type/array2d.html"},{"title":"layer_type –  ","text":"type, public :: layer_type Inherited by type~~layer_type~~InheritedByGraph type~layer_type layer_type type~network_type network_type type~network_type->type~layer_type layers Help × Graph Key Nodes of different colours represent the following: Graph Key Type Type This Page's Entity This Page's Entity Solid arrows point from a derived type to the parent type which it\n    extends. Dashed arrows point from a derived type to the other\n    types it contains as a components, with a label listing the name(s) of\n    said component(s). Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Variables a activation activation_prime activation_str b w z Constructor layer_type Type-Bound Procedures set_activation Source Code layer_type Components Type Visibility Attributes Name Initial real(kind=rk), public, allocatable :: a (:) activations procedure( activation_function ), public, pointer, nopass :: activation => null() procedure( activation_function ), public, pointer, nopass :: activation_prime => null() character(len=:), public, allocatable :: activation_str activation character string real(kind=rk), public, allocatable :: b (:) biases real(kind=rk), public, allocatable :: w (:,:) weights real(kind=rk), public, allocatable :: z (:) arg. to activation function Constructor public interface layer_type private function constructor (this_size, next_size) result(layer) Layer class constructor. this_size is the number of neurons in the layer.\n next_size is the number of neurons in the next layer, used to allocate\n the weights. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: this_size integer(kind=ik), intent(in) :: next_size Return Value type( layer_type ) Type-Bound Procedures procedure, public, pass(self) :: set_activation private pure elemental subroutine set_activation (self, activation) Sets the activation function. Input string must match one of\n provided activation functions, otherwise it defaults to sigmoid.\n If activation not present, defaults to sigmoid. Arguments Type Intent Optional Attributes Name class( layer_type ), intent(inout) :: self character(len=*), intent(in) :: activation Source Code type :: layer_type real ( rk ), allocatable :: a (:) !! activations real ( rk ), allocatable :: b (:) !! biases real ( rk ), allocatable :: w (:,:) !! weights real ( rk ), allocatable :: z (:) !! arg. to activation function procedure ( activation_function ), pointer , nopass :: activation => null () procedure ( activation_function ), pointer , nopass :: activation_prime => null () character ( len = :), allocatable :: activation_str !! activation character string contains procedure , public , pass ( self ) :: set_activation end type layer_type","tags":"","loc":"type/layer_type.html"},{"title":"network_type –  ","text":"type, public :: network_type Inherits type~~network_type~~InheritsGraph type~network_type network_type type~layer_type layer_type type~network_type->type~layer_type layers Help × Graph Key Nodes of different colours represent the following: Graph Key Type Type This Page's Entity This Page's Entity Solid arrows point from a derived type to the parent type which it\n    extends. Dashed arrows point from a derived type to the other\n    types it contains as a components, with a label listing the name(s) of\n    said component(s). Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Variables dims layers Constructor network_type Type-Bound Procedures accuracy backprop fwdprop init load loss output output_batch output_single save set_activation set_activation_equal set_activation_layers sync train train_batch train_epochs train_single update Source Code network_type Components Type Visibility Attributes Name Initial integer(kind=ik), public, allocatable :: dims (:) type( layer_type ), public, allocatable :: layers (:) Constructor public interface network_type private function net_constructor (dims, activation) result(net) Network class constructor. Size of input array dims indicates the total\n number of layers (input + hidden + output), and the value of its elements\n corresponds the size of each layer. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (:) character(len=*), intent(in), optional :: activation Return Value type( network_type ) Type-Bound Procedures procedure, public, pass(self) :: accuracy private pure function accuracy (self, x, y) Given input x and output y, evaluates the position of the\n maximum value of the output and returns the number of matches\n relative to the size of the dataset. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) Return Value real(kind=rk) procedure, public, pass(self) :: backprop private pure subroutine backprop (self, y, dw, db) Applies a backward propagation through the network\n and returns the weight and bias gradients. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: y (:) type( array2d ), intent(out), allocatable :: dw (:) type( array1d ), intent(out), allocatable :: db (:) procedure, public, pass(self) :: fwdprop private pure subroutine fwdprop (self, x) Performs the forward propagation and stores arguments to activation\n functions and activations themselves for use in backprop. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:) procedure, public, pass(self) :: init private subroutine init (self, dims) Allocates and initializes the layers with given dimensions dims. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self integer(kind=ik), intent(in) :: dims (:) procedure, public, pass(self) :: load private subroutine load (self, filename) Loads the network from file. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: filename procedure, public, pass(self) :: loss private pure function loss (self, x, y) Given input x and expected output y, returns the loss of the network. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:) real(kind=rk), intent(in) :: y (:) Return Value real(kind=rk) generic, public :: output => output_batch , output_single private pure function output_batch (self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a batch of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:,:) Return Value real(kind=rk),\n  allocatable, (:,:) private pure function output_single (self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a single sample of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk),\n  allocatable, (:) procedure, public, pass(self) :: output_batch private pure function output_batch (self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a batch of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:,:) Return Value real(kind=rk),\n  allocatable, (:,:) procedure, public, pass(self) :: output_single private pure function output_single (self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a single sample of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk),\n  allocatable, (:) procedure, public, pass(self) :: save private subroutine save (self, filename) Saves the network to a file. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: filename generic, public :: set_activation => set_activation_equal , set_activation_layers private pure subroutine set_activation_equal (self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set an activation function\n for all layers at once. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation private pure subroutine set_activation_layers (self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set different activation functions\n for each layer separately. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation (size(self%layers)) procedure, public, pass(self) :: set_activation_equal private pure subroutine set_activation_equal (self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set an activation function\n for all layers at once. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation procedure, public, pass(self) :: set_activation_layers private pure subroutine set_activation_layers (self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set different activation functions\n for each layer separately. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation (size(self%layers)) procedure, public, pass(self) :: sync private subroutine sync (self, image) Broadcasts network weights and biases from\n specified image to all others. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self integer(kind=ik), intent(in) :: image generic, public :: train => train_batch , train_epochs , train_single private subroutine train_batch (self, x, y, eta) Trains a network using input data x and output data y,\n and learning rate eta. The learning rate is normalized\n with the size of the data batch.\n mini-batch size\n number of layers Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta private subroutine train_epochs (self, x, y, eta, num_epochs, batch_size) Trains for num_epochs epochs with mini-bachtes of size equal to batch_size. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta integer(kind=ik), intent(in) :: num_epochs integer(kind=ik), intent(in) :: batch_size private pure subroutine train_single (self, x, y, eta) Trains a network using a single set of input data x and output data y,\n and learning rate eta. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:) real(kind=rk), intent(in) :: y (:) real(kind=rk), intent(in) :: eta procedure, public, pass(self) :: train_batch private subroutine train_batch (self, x, y, eta) Trains a network using input data x and output data y,\n and learning rate eta. The learning rate is normalized\n with the size of the data batch.\n mini-batch size\n number of layers Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta procedure, public, pass(self) :: train_epochs private subroutine train_epochs (self, x, y, eta, num_epochs, batch_size) Trains for num_epochs epochs with mini-bachtes of size equal to batch_size. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta integer(kind=ik), intent(in) :: num_epochs integer(kind=ik), intent(in) :: batch_size procedure, public, pass(self) :: train_single private pure subroutine train_single (self, x, y, eta) Trains a network using a single set of input data x and output data y,\n and learning rate eta. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:) real(kind=rk), intent(in) :: y (:) real(kind=rk), intent(in) :: eta procedure, public, pass(self) :: update private pure subroutine update (self, dw, db, eta) Updates network weights and biases with gradients dw and db,\n scaled by learning rate eta.\n update biases\n update weights Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self class( array2d ), intent(in) :: dw (:) class( array1d ), intent(in) :: db (:) real(kind=rk), intent(in) :: eta Source Code type :: network_type type ( layer_type ), allocatable :: layers (:) integer ( ik ), allocatable :: dims (:) contains procedure , public , pass ( self ) :: accuracy procedure , public , pass ( self ) :: backprop procedure , public , pass ( self ) :: fwdprop procedure , public , pass ( self ) :: init procedure , public , pass ( self ) :: load procedure , public , pass ( self ) :: loss procedure , public , pass ( self ) :: output_batch procedure , public , pass ( self ) :: output_single procedure , public , pass ( self ) :: save procedure , public , pass ( self ) :: set_activation_equal procedure , public , pass ( self ) :: set_activation_layers procedure , public , pass ( self ) :: sync procedure , public , pass ( self ) :: train_batch procedure , public , pass ( self ) :: train_epochs procedure , public , pass ( self ) :: train_single procedure , public , pass ( self ) :: update generic , public :: output => output_batch , output_single generic , public :: set_activation => set_activation_equal , set_activation_layers generic , public :: train => train_batch , train_epochs , train_single end type network_type","tags":"","loc":"type/network_type.html"},{"title":"tile_indices – ","text":"public pure function tile_indices(dims) Given input global array size, return start and end index\n of a parallel 1-d tile that correspond to this image.\n start and end indices assuming equal tile sizes\n if we have any remainder, distribute it to the tiles at the end Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims Return Value integer(kind=ik)\n  (2) Called by proc~~tile_indices~~CalledByGraph proc~tile_indices tile_indices proc~train_batch train_batch proc~train_batch->proc~tile_indices Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code tile_indices Source Code pure function tile_indices ( dims ) !! Given input global array size, return start and end index !! of a parallel 1-d tile that correspond to this image. integer ( ik ), intent ( in ) :: dims integer ( ik ) :: tile_indices ( 2 ) integer ( ik ) :: offset , tile_size tile_size = dims / num_images () !! start and end indices assuming equal tile sizes tile_indices ( 1 ) = ( this_image () - 1 ) * tile_size + 1 tile_indices ( 2 ) = tile_indices ( 1 ) + tile_size - 1 !! if we have any remainder, distribute it to the tiles at the end offset = num_images () - mod ( dims , num_images ()) if ( this_image () > offset ) then tile_indices ( 1 ) = tile_indices ( 1 ) + this_image () - offset - 1 tile_indices ( 2 ) = tile_indices ( 2 ) + this_image () - offset end if end function tile_indices","tags":"","loc":"proc/tile_indices.html"},{"title":"array1d_constructor – ","text":"private pure function array1d_constructor(length) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: length Return Value type( array1d ) Called by proc~~array1d_constructor~~CalledByGraph proc~array1d_constructor array1d_constructor interface~array1d array1d interface~array1d->proc~array1d_constructor proc~db_init db_init proc~db_init->interface~array1d proc~backprop backprop proc~backprop->proc~db_init proc~train_batch train_batch proc~train_batch->proc~db_init Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code array1d_constructor Source Code pure type ( array1d ) function array1d_constructor ( length ) result ( a ) !! Overloads the default type constructor. integer ( ik ), intent ( in ) :: length allocate ( a % array ( length )) a % array = 0 end function array1d_constructor","tags":"","loc":"proc/array1d_constructor.html"},{"title":"array2d_constructor – ","text":"private pure function array2d_constructor(dims) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (2) Return Value type( array2d ) Called by proc~~array2d_constructor~~CalledByGraph proc~array2d_constructor array2d_constructor interface~array2d array2d interface~array2d->proc~array2d_constructor proc~dw_init dw_init proc~dw_init->interface~array2d proc~backprop backprop proc~backprop->proc~dw_init proc~train_batch train_batch proc~train_batch->proc~dw_init Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code array2d_constructor Source Code pure type ( array2d ) function array2d_constructor ( dims ) result ( a ) !! Overloads the default type constructor. integer ( ik ), intent ( in ) :: dims ( 2 ) allocate ( a % array ( dims ( 1 ), dims ( 2 ))) a % array = 0 end function array2d_constructor","tags":"","loc":"proc/array2d_constructor.html"},{"title":"constructor – ","text":"private function constructor(this_size, next_size) result(layer) Layer class constructor. this_size is the number of neurons in the layer.\n next_size is the number of neurons in the next layer, used to allocate\n the weights. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: this_size integer(kind=ik), intent(in) :: next_size Return Value type( layer_type ) Calls proc~~constructor~~CallsGraph proc~constructor constructor interface~randn randn proc~constructor->interface~randn proc~randn1d randn1d interface~randn->proc~randn1d proc~randn2d randn2d interface~randn->proc~randn2d Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Called by proc~~constructor~~CalledByGraph proc~constructor constructor interface~layer_type layer_type interface~layer_type->proc~constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code constructor Source Code type ( layer_type ) function constructor ( this_size , next_size ) result ( layer ) !! Layer class constructor. this_size is the number of neurons in the layer. !! next_size is the number of neurons in the next layer, used to allocate !! the weights. integer ( ik ), intent ( in ) :: this_size , next_size allocate ( layer % a ( this_size )) allocate ( layer % z ( this_size )) layer % a = 0 layer % z = 0 layer % w = randn ( this_size , next_size ) / this_size layer % b = randn ( this_size ) end function constructor","tags":"","loc":"proc/constructor.html"},{"title":"db_co_sum – ","text":"public subroutine db_co_sum(db) Performs a collective sum of bias tendencies. Arguments Type Intent Optional Attributes Name type( array1d ), intent(inout), allocatable :: db (:) Called by proc~~db_co_sum~~CalledByGraph proc~db_co_sum db_co_sum proc~train_batch train_batch proc~train_batch->proc~db_co_sum Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code db_co_sum Source Code subroutine db_co_sum ( db ) !! Performs a collective sum of bias tendencies. type ( array1d ), allocatable , intent ( in out ) :: db (:) integer ( ik ) :: n do n = 2 , size ( db ) #ifdef CAF call co_sum ( db ( n ) % array ) #endif end do end subroutine db_co_sum","tags":"","loc":"proc/db_co_sum.html"},{"title":"db_init – ","text":"public pure subroutine db_init(db, dims) Initialises biases structure. Arguments Type Intent Optional Attributes Name type( array1d ), intent(inout), allocatable :: db (:) integer(kind=ik), intent(in) :: dims (:) Calls proc~~db_init~~CallsGraph proc~db_init db_init interface~array1d array1d proc~db_init->interface~array1d proc~array1d_constructor array1d_constructor interface~array1d->proc~array1d_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Called by proc~~db_init~~CalledByGraph proc~db_init db_init proc~backprop backprop proc~backprop->proc~db_init proc~train_batch train_batch proc~train_batch->proc~db_init Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code db_init Source Code pure subroutine db_init ( db , dims ) !! Initialises biases structure. type ( array1d ), allocatable , intent ( in out ) :: db (:) integer ( ik ), intent ( in ) :: dims (:) integer ( ik ) :: n , nm nm = size ( dims ) allocate ( db ( nm )) do n = 1 , nm - 1 db ( n ) = array1d ( dims ( n )) end do db ( n ) = array1d ( dims ( n )) end subroutine db_init","tags":"","loc":"proc/db_init.html"},{"title":"dw_co_sum – ","text":"public subroutine dw_co_sum(dw) Performs a collective sum of weights tendencies. Arguments Type Intent Optional Attributes Name type( array2d ), intent(inout), allocatable :: dw (:) Called by proc~~dw_co_sum~~CalledByGraph proc~dw_co_sum dw_co_sum proc~train_batch train_batch proc~train_batch->proc~dw_co_sum Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code dw_co_sum Source Code subroutine dw_co_sum ( dw ) !! Performs a collective sum of weights tendencies. type ( array2d ), allocatable , intent ( in out ) :: dw (:) integer ( ik ) :: n do n = 1 , size ( dw ) - 1 #ifdef CAF call co_sum ( dw ( n ) % array ) #endif end do end subroutine dw_co_sum","tags":"","loc":"proc/dw_co_sum.html"},{"title":"dw_init – ","text":"public pure subroutine dw_init(dw, dims) Initialises weights structure. Arguments Type Intent Optional Attributes Name type( array2d ), intent(inout), allocatable :: dw (:) integer(kind=ik), intent(in) :: dims (:) Calls proc~~dw_init~~CallsGraph proc~dw_init dw_init interface~array2d array2d proc~dw_init->interface~array2d proc~array2d_constructor array2d_constructor interface~array2d->proc~array2d_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Called by proc~~dw_init~~CalledByGraph proc~dw_init dw_init proc~backprop backprop proc~backprop->proc~dw_init proc~train_batch train_batch proc~train_batch->proc~dw_init Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code dw_init Source Code pure subroutine dw_init ( dw , dims ) !! Initialises weights structure. type ( array2d ), allocatable , intent ( in out ) :: dw (:) integer ( ik ), intent ( in ) :: dims (:) integer ( ik ) :: n , nm nm = size ( dims ) allocate ( dw ( nm )) do n = 1 , nm - 1 dw ( n ) = array2d ( dims ( n : n + 1 )) end do dw ( n ) = array2d ([ dims ( n ), 1 ]) end subroutine dw_init","tags":"","loc":"proc/dw_init.html"},{"title":"set_activation – ","text":"private pure elemental subroutine set_activation(self, activation) Sets the activation function. Input string must match one of\n provided activation functions, otherwise it defaults to sigmoid.\n If activation not present, defaults to sigmoid. Arguments Type Intent Optional Attributes Name class( layer_type ), intent(inout) :: self character(len=*), intent(in) :: activation Contents Source Code set_activation Source Code pure elemental subroutine set_activation ( self , activation ) !! Sets the activation function. Input string must match one of !! provided activation functions, otherwise it defaults to sigmoid. !! If activation not present, defaults to sigmoid. class ( layer_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: activation select case ( trim ( activation )) case ( 'gaussian' ) self % activation => gaussian self % activation_prime => gaussian_prime self % activation_str = 'gaussian' case ( 'relu' ) self % activation => relu self % activation_prime => relu_prime self % activation_str = 'relu' case ( 'sigmoid' ) self % activation => sigmoid self % activation_prime => sigmoid_prime self % activation_str = 'sigmoid' case ( 'step' ) self % activation => step self % activation_prime => step_prime self % activation_str = 'step' case ( 'tanh' ) self % activation => tanhf self % activation_prime => tanh_prime self % activation_str = 'tanh' case default self % activation => sigmoid self % activation_prime => sigmoid_prime self % activation_str = 'sigmoid' end select end subroutine set_activation","tags":"","loc":"proc/set_activation.html"},{"title":"array1d – ","text":"public interface array1d Calls interface~~array1d~~CallsGraph interface~array1d array1d proc~array1d_constructor array1d_constructor interface~array1d->proc~array1d_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Called by interface~~array1d~~CalledByGraph interface~array1d array1d proc~db_init db_init proc~db_init->interface~array1d proc~backprop backprop proc~backprop->proc~db_init proc~train_batch train_batch proc~train_batch->proc~db_init Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Module Procedures array1d_constructor Module Procedures private pure function array1d_constructor (length) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: length Return Value type( array1d )","tags":"","loc":"interface/array1d.html"},{"title":"array2d – ","text":"public interface array2d Calls interface~~array2d~~CallsGraph interface~array2d array2d proc~array2d_constructor array2d_constructor interface~array2d->proc~array2d_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Called by interface~~array2d~~CalledByGraph interface~array2d array2d proc~dw_init dw_init proc~dw_init->interface~array2d proc~backprop backprop proc~backprop->proc~dw_init proc~train_batch train_batch proc~train_batch->proc~dw_init Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Module Procedures array2d_constructor Module Procedures private pure function array2d_constructor (dims) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (2) Return Value type( array2d )","tags":"","loc":"interface/array2d.html"},{"title":"layer_type – ","text":"public interface layer_type Calls interface~~layer_type~~CallsGraph interface~layer_type layer_type proc~constructor constructor interface~layer_type->proc~constructor interface~randn randn proc~constructor->interface~randn proc~randn1d randn1d interface~randn->proc~randn1d proc~randn2d randn2d interface~randn->proc~randn2d Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Module Procedures constructor Module Procedures private function constructor (this_size, next_size) result(layer) Layer class constructor. this_size is the number of neurons in the layer.\n next_size is the number of neurons in the next layer, used to allocate\n the weights. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: this_size integer(kind=ik), intent(in) :: next_size Return Value type( layer_type )","tags":"","loc":"interface/layer_type.html"},{"title":"randn1d – ","text":"private function randn1d(n) result(r) Generates n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (n) Called by proc~~randn1d~~CalledByGraph proc~randn1d randn1d interface~randn randn interface~randn->proc~randn1d proc~constructor constructor proc~constructor->interface~randn interface~layer_type layer_type interface~layer_type->proc~constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code randn1d Source Code function randn1d ( n ) result ( r ) !! Generates n random numbers with a normal distribution. integer ( ik ), intent ( in ) :: n real ( rk ) :: r ( n ), r2 ( n ) call random_number ( r ) call random_number ( r2 ) r = sqrt ( - 2 * log ( r )) * cos ( 2 * pi * r2 ) end function randn1d","tags":"","loc":"proc/randn1d.html"},{"title":"randn2d – ","text":"private function randn2d(m, n) result(r) Generates m x n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: m integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (m,n) Called by proc~~randn2d~~CalledByGraph proc~randn2d randn2d interface~randn randn interface~randn->proc~randn2d proc~constructor constructor proc~constructor->interface~randn interface~layer_type layer_type interface~layer_type->proc~constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code randn2d Source Code function randn2d ( m , n ) result ( r ) !! Generates m x n random numbers with a normal distribution. integer ( ik ), intent ( in ) :: m , n real ( rk ) :: r ( m , n ), r2 ( m , n ) call random_number ( r ) call random_number ( r2 ) r = sqrt ( - 2 * log ( r )) * cos ( 2 * pi * r2 ) end function randn2d","tags":"","loc":"proc/randn2d.html"},{"title":"randn – ","text":"public interface randn Calls interface~~randn~~CallsGraph interface~randn randn proc~randn1d randn1d interface~randn->proc~randn1d proc~randn2d randn2d interface~randn->proc~randn2d Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Called by interface~~randn~~CalledByGraph interface~randn randn proc~constructor constructor proc~constructor->interface~randn interface~layer_type layer_type interface~layer_type->proc~constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Module Procedures randn1d randn2d Module Procedures private function randn1d (n) result(r) Generates n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (n) private function randn2d (m, n) result(r) Generates m x n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: m integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (m,n)","tags":"","loc":"interface/randn.html"},{"title":"accuracy – ","text":"private pure function accuracy(self, x, y) Given input x and output y, evaluates the position of the\n maximum value of the output and returns the number of matches\n relative to the size of the dataset. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) Return Value real(kind=rk) Contents Source Code accuracy Source Code pure real ( rk ) function accuracy ( self , x , y ) !! Given input x and output y, evaluates the position of the !! maximum value of the output and returns the number of matches !! relative to the size of the dataset. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:,:), y (:,:) integer ( ik ) :: i , good good = 0 do i = 1 , size ( x , dim = 2 ) if ( all ( maxloc ( self % output ( x (:, i ))) == maxloc ( y (:, i )))) then good = good + 1 end if end do accuracy = real ( good , kind = rk ) / size ( x , dim = 2 ) end function accuracy","tags":"","loc":"proc/accuracy.html"},{"title":"loss – ","text":"private pure function loss(self, x, y) Given input x and expected output y, returns the loss of the network. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:) real(kind=rk), intent(in) :: y (:) Return Value real(kind=rk) Contents Source Code loss Source Code pure real ( rk ) function loss ( self , x , y ) !! Given input x and expected output y, returns the loss of the network. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:), y (:) loss = 0.5 * sum (( y - self % output ( x )) ** 2 ) / size ( x ) end function loss","tags":"","loc":"proc/loss.html"},{"title":"net_constructor – ","text":"private function net_constructor(dims, activation) result(net) Network class constructor. Size of input array dims indicates the total\n number of layers (input + hidden + output), and the value of its elements\n corresponds the size of each layer. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (:) character(len=*), intent(in), optional :: activation Return Value type( network_type ) Called by proc~~net_constructor~~CalledByGraph proc~net_constructor net_constructor interface~network_type network_type interface~network_type->proc~net_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code net_constructor Source Code type ( network_type ) function net_constructor ( dims , activation ) result ( net ) !! Network class constructor. Size of input array dims indicates the total !! number of layers (input + hidden + output), and the value of its elements !! corresponds the size of each layer. integer ( ik ), intent ( in ) :: dims (:) character ( len =* ), intent ( in ), optional :: activation call net % init ( dims ) if ( present ( activation )) then call net % set_activation ( activation ) else call net % set_activation ( 'sigmoid' ) end if call net % sync ( 1 ) end function net_constructor","tags":"","loc":"proc/net_constructor.html"},{"title":"output_batch – ","text":"private pure function output_batch(self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a batch of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:,:) Return Value real(kind=rk),\n  allocatable,(:,:) Contents Source Code output_batch Source Code pure function output_batch ( self , x ) result ( a ) !! Use forward propagation to compute the output of the network. !! This specific procedure is for a batch of 1-d input data. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:,:) real ( rk ), allocatable :: a (:,:) integer ( ik ) :: i allocate ( a ( self % dims ( size ( self % dims )), size ( x , dim = 2 ))) do i = 1 , size ( x , dim = 2 ) a (:, i ) = self % output_single ( x (:, i )) end do end function output_batch","tags":"","loc":"proc/output_batch.html"},{"title":"output_single – ","text":"private pure function output_single(self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a single sample of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk),\n  allocatable,(:) Calls proc~~output_single~~CallsGraph proc~output_single output_single layers layers proc~output_single->layers Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code output_single Source Code pure function output_single ( self , x ) result ( a ) !! Use forward propagation to compute the output of the network. !! This specific procedure is for a single sample of 1-d input data. class ( network_type ), intent ( in ) :: self real ( rk ), intent ( in ) :: x (:) real ( rk ), allocatable :: a (:) integer ( ik ) :: n associate ( layers => self % layers ) a = self % layers ( 2 ) % activation ( matmul ( transpose ( layers ( 1 ) % w ), x ) + layers ( 2 ) % b ) do n = 3 , size ( layers ) a = self % layers ( n ) % activation ( matmul ( transpose ( layers ( n - 1 ) % w ), a ) + layers ( n ) % b ) end do end associate end function output_single","tags":"","loc":"proc/output_single.html"},{"title":"backprop – ","text":"private pure subroutine backprop(self, y, dw, db) Applies a backward propagation through the network\n and returns the weight and bias gradients. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: y (:) type( array2d ), intent(out), allocatable :: dw (:) type( array1d ), intent(out), allocatable :: db (:) Calls proc~~backprop~~CallsGraph proc~backprop backprop proc~db_init db_init proc~backprop->proc~db_init proc~dw_init dw_init proc~backprop->proc~dw_init dims dims proc~backprop->dims layers layers proc~backprop->layers interface~array1d array1d proc~db_init->interface~array1d interface~array2d array2d proc~dw_init->interface~array2d proc~array2d_constructor array2d_constructor interface~array2d->proc~array2d_constructor proc~array1d_constructor array1d_constructor interface~array1d->proc~array1d_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code backprop Source Code pure subroutine backprop ( self , y , dw , db ) !! Applies a backward propagation through the network !! and returns the weight and bias gradients. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: y (:) type ( array2d ), allocatable , intent ( out ) :: dw (:) type ( array1d ), allocatable , intent ( out ) :: db (:) integer ( ik ) :: n , nm associate ( dims => self % dims , layers => self % layers ) call db_init ( db , dims ) call dw_init ( dw , dims ) n = size ( dims ) db ( n ) % array = ( layers ( n ) % a - y ) * self % layers ( n ) % activation_prime ( layers ( n ) % z ) dw ( n - 1 ) % array = matmul ( reshape ( layers ( n - 1 ) % a , [ dims ( n - 1 ), 1 ]),& reshape ( db ( n ) % array , [ 1 , dims ( n )])) do n = size ( dims ) - 1 , 2 , - 1 db ( n ) % array = matmul ( layers ( n ) % w , db ( n + 1 ) % array )& * self % layers ( n ) % activation_prime ( layers ( n ) % z ) dw ( n - 1 ) % array = matmul ( reshape ( layers ( n - 1 ) % a , [ dims ( n - 1 ), 1 ]),& reshape ( db ( n ) % array , [ 1 , dims ( n )])) end do end associate end subroutine backprop","tags":"","loc":"proc/backprop.html"},{"title":"fwdprop – ","text":"private pure subroutine fwdprop(self, x) Performs the forward propagation and stores arguments to activation\n functions and activations themselves for use in backprop. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:) Calls proc~~fwdprop~~CallsGraph proc~fwdprop fwdprop layers layers proc~fwdprop->layers Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code fwdprop Source Code pure subroutine fwdprop ( self , x ) !! Performs the forward propagation and stores arguments to activation !! functions and activations themselves for use in backprop. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: x (:) integer ( ik ) :: n associate ( layers => self % layers ) layers ( 1 ) % a = x do n = 2 , size ( layers ) layers ( n ) % z = matmul ( transpose ( layers ( n - 1 ) % w ), layers ( n - 1 ) % a ) + layers ( n ) % b layers ( n ) % a = self % layers ( n ) % activation ( layers ( n ) % z ) end do end associate end subroutine fwdprop","tags":"","loc":"proc/fwdprop.html"},{"title":"init – ","text":"private subroutine init(self, dims) Allocates and initializes the layers with given dimensions dims. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self integer(kind=ik), intent(in) :: dims (:) Contents Source Code init Source Code subroutine init ( self , dims ) !! Allocates and initializes the layers with given dimensions dims. class ( network_type ), intent ( in out ) :: self integer ( ik ), intent ( in ) :: dims (:) integer ( ik ) :: n self % dims = dims if (. not . allocated ( self % layers )) allocate ( self % layers ( size ( dims ))) do n = 1 , size ( dims ) - 1 self % layers ( n ) = layer_type ( dims ( n ), dims ( n + 1 )) end do self % layers ( n ) = layer_type ( dims ( n ), 1 ) self % layers ( 1 ) % b = 0 self % layers ( size ( dims )) % w = 0 end subroutine init","tags":"","loc":"proc/init.html"},{"title":"load – ","text":"private subroutine load(self, filename) Loads the network from file. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: filename Contents Source Code load Source Code subroutine load ( self , filename ) !! Loads the network from file. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: filename integer ( ik ) :: fileunit , n , num_layers , layer_idx integer ( ik ), allocatable :: dims (:) character ( len = 100 ) :: buffer !! activation string open ( newunit = fileunit , file = filename , status = 'old' , action = 'read' ) read ( fileunit , * ) num_layers allocate ( dims ( num_layers )) read ( fileunit , * ) dims call self % init ( dims ) do n = 1 , num_layers read ( fileunit , * ) layer_idx , buffer call self % layers ( layer_idx ) % set_activation ( trim ( buffer )) end do do n = 2 , size ( self % dims ) read ( fileunit , * ) self % layers ( n ) % b end do do n = 1 , size ( self % dims ) - 1 read ( fileunit , * ) self % layers ( n ) % w end do close ( fileunit ) end subroutine load","tags":"","loc":"proc/load.html"},{"title":"save – ","text":"private subroutine save(self, filename) Saves the network to a file. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: filename Contents Source Code save Source Code subroutine save ( self , filename ) !! Saves the network to a file. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: filename integer ( ik ) :: fileunit , n open ( newunit = fileunit , file = filename ) write ( fileunit , fmt =* ) size ( self % dims ) write ( fileunit , fmt =* ) self % dims do n = 1 , size ( self % dims ) write ( fileunit , fmt =* ) n , self % layers ( n ) % activation_str end do do n = 2 , size ( self % dims ) write ( fileunit , fmt =* ) self % layers ( n ) % b end do do n = 1 , size ( self % dims ) - 1 write ( fileunit , fmt =* ) self % layers ( n ) % w end do close ( fileunit ) end subroutine save","tags":"","loc":"proc/save.html"},{"title":"set_activation_equal – ","text":"private pure subroutine set_activation_equal(self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set an activation function\n for all layers at once. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation Contents Source Code set_activation_equal Source Code pure subroutine set_activation_equal ( self , activation ) !! A thin wrapper around layer % set_activation(). !! This method can be used to set an activation function !! for all layers at once. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: activation call self % layers (:) % set_activation ( activation ) end subroutine set_activation_equal","tags":"","loc":"proc/set_activation_equal.html"},{"title":"set_activation_layers – ","text":"private pure subroutine set_activation_layers(self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set different activation functions\n for each layer separately. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation (size(self%layers)) Contents Source Code set_activation_layers Source Code pure subroutine set_activation_layers ( self , activation ) !! A thin wrapper around layer % set_activation(). !! This method can be used to set different activation functions !! for each layer separately. class ( network_type ), intent ( in out ) :: self character ( len =* ), intent ( in ) :: activation ( size ( self % layers )) call self % layers (:) % set_activation ( activation ) end subroutine set_activation_layers","tags":"","loc":"proc/set_activation_layers.html"},{"title":"sync – ","text":"private subroutine sync(self, image) Broadcasts network weights and biases from\n specified image to all others. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self integer(kind=ik), intent(in) :: image Contents Source Code sync Source Code subroutine sync ( self , image ) !! Broadcasts network weights and biases from !! specified image to all others. class ( network_type ), intent ( in out ) :: self integer ( ik ), intent ( in ) :: image integer ( ik ) :: n if ( num_images () == 1 ) return layers : do n = 1 , size ( self % dims ) #ifdef CAF call co_broadcast ( self % layers ( n ) % b , image ) call co_broadcast ( self % layers ( n ) % w , image ) #endif end do layers end subroutine sync","tags":"","loc":"proc/sync.html"},{"title":"train_batch – ","text":"private subroutine train_batch(self, x, y, eta) Trains a network using input data x and output data y,\n and learning rate eta. The learning rate is normalized\n with the size of the data batch.\n mini-batch size\n number of layers Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta Calls proc~~train_batch~~CallsGraph proc~train_batch train_batch proc~dw_co_sum dw_co_sum proc~train_batch->proc~dw_co_sum proc~db_co_sum db_co_sum proc~train_batch->proc~db_co_sum proc~tile_indices tile_indices proc~train_batch->proc~tile_indices proc~db_init db_init proc~train_batch->proc~db_init proc~dw_init dw_init proc~train_batch->proc~dw_init interface~array1d array1d proc~db_init->interface~array1d interface~array2d array2d proc~dw_init->interface~array2d proc~array2d_constructor array2d_constructor interface~array2d->proc~array2d_constructor proc~array1d_constructor array1d_constructor interface~array1d->proc~array1d_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code train_batch Source Code subroutine train_batch ( self , x , y , eta ) !! Trains a network using input data x and output data y, !! and learning rate eta. The learning rate is normalized !! with the size of the data batch. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: x (:,:), y (:,:), eta type ( array1d ), allocatable :: db (:), db_batch (:) type ( array2d ), allocatable :: dw (:), dw_batch (:) integer ( ik ) :: i , im , n , nm integer ( ik ) :: is , ie , indices ( 2 ) im = size ( x , dim = 2 ) !! mini-batch size nm = size ( self % dims ) !! number of layers ! get start and end index for mini-batch indices = tile_indices ( im ) is = indices ( 1 ) ie = indices ( 2 ) call db_init ( db_batch , self % dims ) call dw_init ( dw_batch , self % dims ) do concurrent ( i = is : ie ) call self % fwdprop ( x (:, i )) call self % backprop ( y (:, i ), dw , db ) do concurrent ( n = 1 : nm ) dw_batch ( n ) % array = dw_batch ( n ) % array + dw ( n ) % array db_batch ( n ) % array = db_batch ( n ) % array + db ( n ) % array end do end do if ( num_images () > 1 ) then call dw_co_sum ( dw_batch ) call db_co_sum ( db_batch ) end if call self % update ( dw_batch , db_batch , eta / im ) end subroutine train_batch","tags":"","loc":"proc/train_batch.html"},{"title":"train_epochs – ","text":"private subroutine train_epochs(self, x, y, eta, num_epochs, batch_size) Trains for num_epochs epochs with mini-bachtes of size equal to batch_size. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta integer(kind=ik), intent(in) :: num_epochs integer(kind=ik), intent(in) :: batch_size Contents Source Code train_epochs Source Code subroutine train_epochs ( self , x , y , eta , num_epochs , batch_size ) !! Trains for num_epochs epochs with mini-bachtes of size equal to batch_size. class ( network_type ), intent ( in out ) :: self integer ( ik ), intent ( in ) :: num_epochs , batch_size real ( rk ), intent ( in ) :: x (:,:), y (:,:), eta integer ( ik ) :: i , n , nsamples , nbatch integer ( ik ) :: batch_start , batch_end real ( rk ) :: pos nsamples = size ( y , dim = 2 ) nbatch = nsamples / batch_size epochs : do n = 1 , num_epochs batches : do i = 1 , nbatch !pull a random mini-batch from the dataset call random_number ( pos ) batch_start = int ( pos * ( nsamples - batch_size + 1 )) if ( batch_start == 0 ) batch_start = 1 batch_end = batch_start + batch_size - 1 call self % train ( x (:, batch_start : batch_end ), y (:, batch_start : batch_end ), eta ) end do batches end do epochs end subroutine train_epochs","tags":"","loc":"proc/train_epochs.html"},{"title":"train_single – ","text":"private pure subroutine train_single(self, x, y, eta) Trains a network using a single set of input data x and output data y,\n and learning rate eta. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:) real(kind=rk), intent(in) :: y (:) real(kind=rk), intent(in) :: eta Contents Source Code train_single Source Code pure subroutine train_single ( self , x , y , eta ) !! Trains a network using a single set of input data x and output data y, !! and learning rate eta. class ( network_type ), intent ( in out ) :: self real ( rk ), intent ( in ) :: x (:), y (:), eta type ( array2d ), allocatable :: dw (:) type ( array1d ), allocatable :: db (:) call self % fwdprop ( x ) call self % backprop ( y , dw , db ) call self % update ( dw , db , eta ) end subroutine train_single","tags":"","loc":"proc/train_single.html"},{"title":"update – ","text":"private pure subroutine update(self, dw, db, eta) Updates network weights and biases with gradients dw and db,\n scaled by learning rate eta.\n update biases\n update weights Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self class( array2d ), intent(in) :: dw (:) class( array1d ), intent(in) :: db (:) real(kind=rk), intent(in) :: eta Calls proc~~update~~CallsGraph proc~update update layers layers proc~update->layers Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code update Source Code pure subroutine update ( self , dw , db , eta ) !! Updates network weights and biases with gradients dw and db, !! scaled by learning rate eta. class ( network_type ), intent ( in out ) :: self class ( array2d ), intent ( in ) :: dw (:) class ( array1d ), intent ( in ) :: db (:) real ( rk ), intent ( in ) :: eta integer ( ik ) :: n associate ( layers => self % layers , nm => size ( self % dims )) !! update biases do concurrent ( n = 2 : nm ) layers ( n ) % b = layers ( n ) % b - eta * db ( n ) % array end do !! update weights do concurrent ( n = 1 : nm - 1 ) layers ( n ) % w = layers ( n ) % w - eta * dw ( n ) % array end do end associate end subroutine update","tags":"","loc":"proc/update.html"},{"title":"network_type – ","text":"public interface network_type Calls interface~~network_type~~CallsGraph interface~network_type network_type proc~net_constructor net_constructor interface~network_type->proc~net_constructor Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Module Procedures net_constructor Module Procedures private function net_constructor (dims, activation) result(net) Network class constructor. Size of input array dims indicates the total\n number of layers (input + hidden + output), and the value of its elements\n corresponds the size of each layer. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (:) character(len=*), intent(in), optional :: activation Return Value type( network_type )","tags":"","loc":"interface/network_type.html"},{"title":"read_binary_file_1d – ","text":"private subroutine read_binary_file_1d(filename, dtype, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:) Called by proc~~read_binary_file_1d~~CalledByGraph proc~read_binary_file_1d read_binary_file_1d interface~read_binary_file read_binary_file interface~read_binary_file->proc~read_binary_file_1d proc~load_mnist load_mnist proc~load_mnist->interface~read_binary_file Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code read_binary_file_1d Source Code subroutine read_binary_file_1d ( filename , dtype , nrec , array ) character ( len =* ), intent ( in ) :: filename integer ( ik ), intent ( in ) :: dtype , nrec real ( rk ), allocatable , intent ( in out ) :: array (:) integer ( ik ) :: fileunit allocate ( array ( nrec )) open ( newunit = fileunit , file = filename , access = 'direct' ,& action = 'read' , recl = dtype * nrec , status = 'old' ) read ( fileunit , rec = 1 ) array close ( fileunit ) end subroutine read_binary_file_1d","tags":"","loc":"proc/read_binary_file_1d.html"},{"title":"read_binary_file_2d – ","text":"private subroutine read_binary_file_2d(filename, dtype, dsize, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: dsize integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:,:) Called by proc~~read_binary_file_2d~~CalledByGraph proc~read_binary_file_2d read_binary_file_2d interface~read_binary_file read_binary_file interface~read_binary_file->proc~read_binary_file_2d proc~load_mnist load_mnist proc~load_mnist->interface~read_binary_file Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code read_binary_file_2d Source Code subroutine read_binary_file_2d ( filename , dtype , dsize , nrec , array ) character ( len =* ), intent ( in ) :: filename integer ( ik ), intent ( in ) :: dtype , dsize , nrec real ( rk ), allocatable , intent ( in out ) :: array (:,:) integer ( ik ) :: fileunit , i allocate ( array ( dsize , nrec )) open ( newunit = fileunit , file = filename , access = 'direct' ,& action = 'read' , recl = dtype * dsize , status = 'old' ) do i = 1 , nrec read ( fileunit , rec = i ) array (:, i ) end do close ( fileunit ) end subroutine read_binary_file_2d","tags":"","loc":"proc/read_binary_file_2d.html"},{"title":"read_binary_file – ","text":"public interface read_binary_file Calls interface~~read_binary_file~~CallsGraph interface~read_binary_file read_binary_file proc~read_binary_file_2d read_binary_file_2d interface~read_binary_file->proc~read_binary_file_2d proc~read_binary_file_1d read_binary_file_1d interface~read_binary_file->proc~read_binary_file_1d Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Called by interface~~read_binary_file~~CalledByGraph interface~read_binary_file read_binary_file proc~load_mnist load_mnist proc~load_mnist->interface~read_binary_file Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Module Procedures read_binary_file_1d read_binary_file_2d Module Procedures private subroutine read_binary_file_1d (filename, dtype, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:) private subroutine read_binary_file_2d (filename, dtype, dsize, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: dsize integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:,:)","tags":"","loc":"interface/read_binary_file.html"},{"title":"gaussian – ","text":"public pure function gaussian(x) result(res) Gaussian activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Called by proc~~gaussian~~CalledByGraph proc~gaussian gaussian proc~gaussian_prime gaussian_prime proc~gaussian_prime->proc~gaussian Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code gaussian Source Code pure function gaussian ( x ) result ( res ) !! Gaussian activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = exp ( - x ** 2 ) end function gaussian","tags":"","loc":"proc/gaussian.html"},{"title":"gaussian_prime – ","text":"public pure function gaussian_prime(x) result(res) First derivative of the Gaussian activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Calls proc~~gaussian_prime~~CallsGraph proc~gaussian_prime gaussian_prime proc~gaussian gaussian proc~gaussian_prime->proc~gaussian Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code gaussian_prime Source Code pure function gaussian_prime ( x ) result ( res ) !! First derivative of the Gaussian activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = - 2 * x * gaussian ( x ) end function gaussian_prime","tags":"","loc":"proc/gaussian_prime.html"},{"title":"relu – ","text":"public pure function relu(x) result(res) REctified Linear Unit (RELU) activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Contents Source Code relu Source Code pure function relu ( x ) result ( res ) !! REctified Linear Unit (RELU) activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = max ( 0. , x ) end function relu","tags":"","loc":"proc/relu.html"},{"title":"relu_prime – ","text":"public pure function relu_prime(x) result(res) First derivative of the REctified Linear Unit (RELU) activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Contents Source Code relu_prime Source Code pure function relu_prime ( x ) result ( res ) !! First derivative of the REctified Linear Unit (RELU) activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) where ( x > 0 ) res = 1 elsewhere res = 0 end where end function relu_prime","tags":"","loc":"proc/relu_prime.html"},{"title":"sigmoid – ","text":"public pure function sigmoid(x) result(res) Sigmoid activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Called by proc~~sigmoid~~CalledByGraph proc~sigmoid sigmoid proc~sigmoid_prime sigmoid_prime proc~sigmoid_prime->proc~sigmoid Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code sigmoid Source Code pure function sigmoid ( x ) result ( res ) !! Sigmoid activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = 1 / ( 1 + exp ( - x )) endfunction sigmoid","tags":"","loc":"proc/sigmoid.html"},{"title":"sigmoid_prime – ","text":"public pure function sigmoid_prime(x) result(res) First derivative of the sigmoid activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Calls proc~~sigmoid_prime~~CallsGraph proc~sigmoid_prime sigmoid_prime proc~sigmoid sigmoid proc~sigmoid_prime->proc~sigmoid Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code sigmoid_prime Source Code pure function sigmoid_prime ( x ) result ( res ) !! First derivative of the sigmoid activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = sigmoid ( x ) * ( 1 - sigmoid ( x )) end function sigmoid_prime","tags":"","loc":"proc/sigmoid_prime.html"},{"title":"step – ","text":"public pure function step(x) result(res) Step activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Contents Source Code step Source Code pure function step ( x ) result ( res ) !! Step activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) where ( x > 0 ) res = 1 elsewhere res = 0 end where end function step","tags":"","loc":"proc/step.html"},{"title":"step_prime – ","text":"public pure function step_prime(x) result(res) First derivative of the step activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Contents Source Code step_prime Source Code pure function step_prime ( x ) result ( res ) !! First derivative of the step activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = 0 end function step_prime","tags":"","loc":"proc/step_prime.html"},{"title":"tanh_prime – ","text":"public pure function tanh_prime(x) result(res) First derivative of the tanh activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Contents Source Code tanh_prime Source Code pure function tanh_prime ( x ) result ( res ) !! First derivative of the tanh activation function. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = 1 - tanh ( x ) ** 2 end function tanh_prime","tags":"","loc":"proc/tanh_prime.html"},{"title":"tanhf – ","text":"public pure function tanhf(x) result(res) Tangent hyperbolic activation function. \n Same as the intrinsic tanh, but must be \n defined here so that we can use procedure\n pointer with it. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Contents Source Code tanhf Source Code pure function tanhf ( x ) result ( res ) !! Tangent hyperbolic activation function. !! Same as the intrinsic tanh, but must be !! defined here so that we can use procedure !! pointer with it. real ( rk ), intent ( in ) :: x (:) real ( rk ) :: res ( size ( x )) res = tanh ( x ) end function tanhf","tags":"","loc":"proc/tanhf.html"},{"title":"activation_function – ","text":"interface public pure function activation_function(x) Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x))","tags":"","loc":"interface/activation_function.html"},{"title":"label_digits – ","text":"public pure function label_digits(labels) result(res) Converts an array of MNIST labels into a form\n that can be input to the network_type instance. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: labels (:) Return Value real(kind=rk)\n  (10,size(labels)) Contents Source Code label_digits Source Code pure function label_digits ( labels ) result ( res ) !! Converts an array of MNIST labels into a form !! that can be input to the network_type instance. real ( rk ), intent ( in ) :: labels (:) real ( rk ) :: res ( 10 , size ( labels )) integer ( ik ) :: i do i = 1 , size ( labels ) res (:, i ) = digits ( labels ( i )) end do end function label_digits","tags":"","loc":"proc/label_digits.html"},{"title":"digits – ","text":"private pure function digits(x) Returns an array of 10 reals, with zeros everywhere\n and a one corresponding to the input number, for example:\n   digits(0) = [1., 0., 0., 0., 0., 0., 0., 0., 0., 0.]\n   digits(1) = [0., 1., 0., 0., 0., 0., 0., 0., 0., 0.]\n   digits(6) = [0., 0., 0., 0., 0., 0., 1., 0., 0., 0.] Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x Return Value real(kind=rk)\n  (10) Contents Source Code digits Source Code pure function digits ( x ) !! Returns an array of 10 reals, with zeros everywhere !! and a one corresponding to the input number, for example: !!   digits(0) = [1., 0., 0., 0., 0., 0., 0., 0., 0., 0.] !!   digits(1) = [0., 1., 0., 0., 0., 0., 0., 0., 0., 0.] !!   digits(6) = [0., 0., 0., 0., 0., 0., 1., 0., 0., 0.] real ( rk ), intent ( in ) :: x real ( rk ) :: digits ( 10 ) digits = 0 digits ( int ( x + 1 )) = 1 end function digits","tags":"","loc":"proc/digits.html"},{"title":"load_mnist – ","text":"public subroutine load_mnist(tr_images, tr_labels, te_images, te_labels, va_images, va_labels) Loads the MNIST dataset into arrays. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(inout), allocatable :: tr_images (:,:) real(kind=rk), intent(inout), allocatable :: tr_labels (:) real(kind=rk), intent(inout), allocatable :: te_images (:,:) real(kind=rk), intent(inout), allocatable :: te_labels (:) real(kind=rk), intent(inout), optional allocatable :: va_images (:,:) real(kind=rk), intent(inout), optional allocatable :: va_labels (:) Calls proc~~load_mnist~~CallsGraph proc~load_mnist load_mnist interface~read_binary_file read_binary_file proc~load_mnist->interface~read_binary_file proc~read_binary_file_2d read_binary_file_2d interface~read_binary_file->proc~read_binary_file_2d proc~read_binary_file_1d read_binary_file_1d interface~read_binary_file->proc~read_binary_file_1d Help × Graph Key Nodes of different colours represent the following: Graph Key Subroutine Subroutine Function Function Interface Interface Unknown Procedure Type Unknown Procedure Type Program Program This Page's Entity This Page's Entity Solid arrows point from a procedure to one which it calls. Dashed \n    arrows point from an interface to procedures which implement that interface.\n    This could include the module procedures in a generic interface or the\n    implementation in a submodule of an interface in a parent module. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Source Code load_mnist Source Code subroutine load_mnist ( tr_images , tr_labels , te_images ,& te_labels , va_images , va_labels ) !! Loads the MNIST dataset into arrays. real ( rk ), allocatable , intent ( in out ) :: tr_images (:,:), tr_labels (:) real ( rk ), allocatable , intent ( in out ) :: te_images (:,:), te_labels (:) real ( rk ), allocatable , intent ( in out ), optional :: va_images (:,:), va_labels (:) integer ( ik ), parameter :: dtype = 4 , image_size = 784 integer ( ik ), parameter :: tr_nimages = 50000 integer ( ik ), parameter :: te_nimages = 10000 integer ( ik ), parameter :: va_nimages = 10000 call read_binary_file ( 'data/mnist/mnist_training_images.dat' ,& dtype , image_size , tr_nimages , tr_images ) call read_binary_file ( 'data/mnist/mnist_training_labels.dat' ,& dtype , tr_nimages , tr_labels ) call read_binary_file ( 'data/mnist/mnist_testing_images.dat' ,& dtype , image_size , te_nimages , te_images ) call read_binary_file ( 'data/mnist/mnist_testing_labels.dat' ,& dtype , te_nimages , te_labels ) if ( present ( va_images ) . and . present ( va_labels )) then call read_binary_file ( 'data/mnist/mnist_validation_images.dat' ,& dtype , image_size , va_nimages , va_images ) call read_binary_file ( 'data/mnist/mnist_validation_labels.dat' ,& dtype , va_nimages , va_labels ) end if end subroutine load_mnist","tags":"","loc":"proc/load_mnist.html"},{"title":"print_image – ","text":"public subroutine print_image(images, labels, n) Prints a single image and label to screen. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: images (:,:) real(kind=rk), intent(in) :: labels (:) integer(kind=ik), intent(in) :: n Contents Source Code print_image Source Code subroutine print_image ( images , labels , n ) !! Prints a single image and label to screen. real ( rk ), intent ( in ) :: images (:,:), labels (:) integer ( ik ), intent ( in ) :: n real ( rk ) :: image ( 28 , 28 ) character ( len = 1 ) :: char_image ( 28 , 28 ) integer ( ik ) i , j image = reshape ( images (:, n ), [ 28 , 28 ]) char_image = '.' where ( image > 0 ) char_image = '#' print * , labels ( n ) do j = 1 , 28 print * , char_image (:, j ) end do end subroutine print_image","tags":"","loc":"proc/print_image.html"},{"title":"mod_parallel – ","text":"Uses mod_kinds module~~mod_parallel~~UsesGraph module~mod_parallel mod_parallel module~mod_kinds mod_kinds module~mod_parallel->module~mod_kinds iso_fortran_env iso_fortran_env module~mod_kinds->iso_fortran_env Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Used by module~~mod_parallel~~UsedByGraph module~mod_parallel mod_parallel module~mod_network mod_network module~mod_network->module~mod_parallel Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Functions tile_indices Functions public pure function tile_indices (dims) Given input global array size, return start and end index\n of a parallel 1-d tile that correspond to this image.\n start and end indices assuming equal tile sizes\n if we have any remainder, distribute it to the tiles at the end Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims Return Value integer(kind=ik)\n  (2)","tags":"","loc":"module/mod_parallel.html"},{"title":"mod_layer – ","text":"Defines the layer type and its methods. Uses mod_kinds mod_activation mod_random module~~mod_layer~~UsesGraph module~mod_layer mod_layer module~mod_random mod_random module~mod_layer->module~mod_random module~mod_activation mod_activation module~mod_layer->module~mod_activation module~mod_kinds mod_kinds module~mod_layer->module~mod_kinds module~mod_random->module~mod_kinds module~mod_activation->module~mod_kinds iso_fortran_env iso_fortran_env module~mod_kinds->iso_fortran_env Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Used by module~~mod_layer~~UsedByGraph module~mod_layer mod_layer module~mod_network mod_network module~mod_network->module~mod_layer Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Interfaces array1d array2d layer_type Derived Types array1d array2d layer_type Functions array1d_constructor array2d_constructor constructor Subroutines db_co_sum db_init dw_co_sum dw_init set_activation Interfaces public interface array1d private pure function array1d_constructor (length) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: length Return Value type( array1d ) public interface array2d private pure function array2d_constructor (dims) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (2) Return Value type( array2d ) public interface layer_type private function constructor (this_size, next_size) result(layer) Layer class constructor. this_size is the number of neurons in the layer.\n next_size is the number of neurons in the next layer, used to allocate\n the weights. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: this_size integer(kind=ik), intent(in) :: next_size Return Value type( layer_type ) Derived Types type, public :: array1d Components Type Visibility Attributes Name Initial real(kind=rk), public, allocatable :: array (:) Constructor private pure function array1d_constructor (length) Overloads the default type constructor. type, public :: array2d Components Type Visibility Attributes Name Initial real(kind=rk), public, allocatable :: array (:,:) Constructor private pure function array2d_constructor (dims) Overloads the default type constructor. type, public :: layer_type Components Type Visibility Attributes Name Initial real(kind=rk), public, allocatable :: a (:) activations procedure( activation_function ), public, pointer, nopass :: activation => null() procedure( activation_function ), public, pointer, nopass :: activation_prime => null() character(len=:), public, allocatable :: activation_str activation character string real(kind=rk), public, allocatable :: b (:) biases real(kind=rk), public, allocatable :: w (:,:) weights real(kind=rk), public, allocatable :: z (:) arg. to activation function Constructor private  function constructor (this_size, next_size) Layer class constructor. this_size is the number of neurons in the layer.\n next_size is the number of neurons in the next layer, used to allocate\n the weights. Type-Bound Procedures procedure, public, pass(self) :: set_activation Functions private pure function array1d_constructor (length) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: length Return Value type( array1d ) private pure function array2d_constructor (dims) result(a) Overloads the default type constructor. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (2) Return Value type( array2d ) private function constructor (this_size, next_size) result(layer) Layer class constructor. this_size is the number of neurons in the layer.\n next_size is the number of neurons in the next layer, used to allocate\n the weights. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: this_size integer(kind=ik), intent(in) :: next_size Return Value type( layer_type ) Subroutines public subroutine db_co_sum (db) Performs a collective sum of bias tendencies. Arguments Type Intent Optional Attributes Name type( array1d ), intent(inout), allocatable :: db (:) public pure subroutine db_init (db, dims) Initialises biases structure. Arguments Type Intent Optional Attributes Name type( array1d ), intent(inout), allocatable :: db (:) integer(kind=ik), intent(in) :: dims (:) public subroutine dw_co_sum (dw) Performs a collective sum of weights tendencies. Arguments Type Intent Optional Attributes Name type( array2d ), intent(inout), allocatable :: dw (:) public pure subroutine dw_init (dw, dims) Initialises weights structure. Arguments Type Intent Optional Attributes Name type( array2d ), intent(inout), allocatable :: dw (:) integer(kind=ik), intent(in) :: dims (:) private pure elemental subroutine set_activation (self, activation) Sets the activation function. Input string must match one of\n provided activation functions, otherwise it defaults to sigmoid.\n If activation not present, defaults to sigmoid. Arguments Type Intent Optional Attributes Name class( layer_type ), intent(inout) :: self character(len=*), intent(in) :: activation","tags":"","loc":"module/mod_layer.html"},{"title":"mod_kinds – ","text":"Uses iso_fortran_env module~~mod_kinds~~UsesGraph module~mod_kinds mod_kinds iso_fortran_env iso_fortran_env module~mod_kinds->iso_fortran_env Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Used by module~~mod_kinds~~UsedByGraph module~mod_kinds mod_kinds module~mod_mnist mod_mnist module~mod_mnist->module~mod_kinds module~mod_io mod_io module~mod_mnist->module~mod_io module~mod_activation mod_activation module~mod_activation->module~mod_kinds module~mod_layer mod_layer module~mod_layer->module~mod_kinds module~mod_layer->module~mod_activation module~mod_random mod_random module~mod_layer->module~mod_random module~mod_network mod_network module~mod_network->module~mod_kinds module~mod_network->module~mod_layer module~mod_parallel mod_parallel module~mod_network->module~mod_parallel module~mod_parallel->module~mod_kinds module~mod_io->module~mod_kinds module~mod_random->module~mod_kinds Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Variables ik rk ik rk rk Variables Type Visibility Attributes Name Initial integer, public, parameter :: ik = int64 integer, public, parameter :: rk = real64 integer, private, parameter :: ik = int32 integer, private, parameter :: rk = real128 integer, private, parameter :: rk = real32","tags":"","loc":"module/mod_kinds.html"},{"title":"mod_random – ","text":"Provides a random number generator with\n normal distribution, centered on zero. Uses mod_kinds module~~mod_random~~UsesGraph module~mod_random mod_random module~mod_kinds mod_kinds module~mod_random->module~mod_kinds iso_fortran_env iso_fortran_env module~mod_kinds->iso_fortran_env Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Used by module~~mod_random~~UsedByGraph module~mod_random mod_random module~mod_layer mod_layer module~mod_layer->module~mod_random module~mod_network mod_network module~mod_network->module~mod_layer Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Variables pi Interfaces randn Functions randn1d randn2d Variables Type Visibility Attributes Name Initial real(kind=rk), private, parameter :: pi = 4*atan(1._rk) Interfaces public interface randn private function randn1d (n) result(r) Generates n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (n) private function randn2d (m, n) result(r) Generates m x n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: m integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (m,n) Functions private function randn1d (n) result(r) Generates n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (n) private function randn2d (m, n) result(r) Generates m x n random numbers with a normal distribution. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: m integer(kind=ik), intent(in) :: n Return Value real(kind=rk)\n  (m,n)","tags":"","loc":"module/mod_random.html"},{"title":"mod_network – ","text":"Uses mod_kinds mod_layer mod_parallel module~~mod_network~~UsesGraph module~mod_network mod_network module~mod_layer mod_layer module~mod_network->module~mod_layer module~mod_parallel mod_parallel module~mod_network->module~mod_parallel module~mod_kinds mod_kinds module~mod_network->module~mod_kinds module~mod_layer->module~mod_kinds module~mod_random mod_random module~mod_layer->module~mod_random module~mod_activation mod_activation module~mod_layer->module~mod_activation module~mod_parallel->module~mod_kinds iso_fortran_env iso_fortran_env module~mod_kinds->iso_fortran_env module~mod_random->module~mod_kinds module~mod_activation->module~mod_kinds Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Interfaces network_type Derived Types network_type Functions accuracy loss net_constructor output_batch output_single Subroutines backprop fwdprop init load save set_activation_equal set_activation_layers sync train_batch train_epochs train_single update Interfaces public interface network_type private function net_constructor (dims, activation) result(net) Network class constructor. Size of input array dims indicates the total\n number of layers (input + hidden + output), and the value of its elements\n corresponds the size of each layer. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (:) character(len=*), intent(in), optional :: activation Return Value type( network_type ) Derived Types type, public :: network_type Components Type Visibility Attributes Name Initial integer(kind=ik), public, allocatable :: dims (:) type( layer_type ), public, allocatable :: layers (:) Constructor private  function net_constructor (dims, activation) Network class constructor. Size of input array dims indicates the total\n number of layers (input + hidden + output), and the value of its elements\n corresponds the size of each layer. Type-Bound Procedures procedure, public, pass(self) :: accuracy procedure, public, pass(self) :: backprop procedure, public, pass(self) :: fwdprop procedure, public, pass(self) :: init procedure, public, pass(self) :: load procedure, public, pass(self) :: loss generic, public :: output => output_batch, output_single procedure, public, pass(self) :: output_batch procedure, public, pass(self) :: output_single procedure, public, pass(self) :: save generic, public :: set_activation => set_activation_equal, set_activation_layers procedure, public, pass(self) :: set_activation_equal procedure, public, pass(self) :: set_activation_layers procedure, public, pass(self) :: sync generic, public :: train => train_batch, train_epochs, train_single procedure, public, pass(self) :: train_batch procedure, public, pass(self) :: train_epochs procedure, public, pass(self) :: train_single procedure, public, pass(self) :: update Functions private pure function accuracy (self, x, y) Given input x and output y, evaluates the position of the\n maximum value of the output and returns the number of matches\n relative to the size of the dataset. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) Return Value real(kind=rk) private pure function loss (self, x, y) Given input x and expected output y, returns the loss of the network. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:) real(kind=rk), intent(in) :: y (:) Return Value real(kind=rk) private function net_constructor (dims, activation) result(net) Network class constructor. Size of input array dims indicates the total\n number of layers (input + hidden + output), and the value of its elements\n corresponds the size of each layer. Arguments Type Intent Optional Attributes Name integer(kind=ik), intent(in) :: dims (:) character(len=*), intent(in), optional :: activation Return Value type( network_type ) private pure function output_batch (self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a batch of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:,:) Return Value real(kind=rk),\n  allocatable, (:,:) private pure function output_single (self, x) result(a) Use forward propagation to compute the output of the network.\n This specific procedure is for a single sample of 1-d input data. Arguments Type Intent Optional Attributes Name class( network_type ), intent(in) :: self real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk),\n  allocatable, (:) Subroutines private pure subroutine backprop (self, y, dw, db) Applies a backward propagation through the network\n and returns the weight and bias gradients. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: y (:) type( array2d ), intent(out), allocatable :: dw (:) type( array1d ), intent(out), allocatable :: db (:) private pure subroutine fwdprop (self, x) Performs the forward propagation and stores arguments to activation\n functions and activations themselves for use in backprop. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:) private subroutine init (self, dims) Allocates and initializes the layers with given dimensions dims. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self integer(kind=ik), intent(in) :: dims (:) private subroutine load (self, filename) Loads the network from file. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: filename private subroutine save (self, filename) Saves the network to a file. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: filename private pure subroutine set_activation_equal (self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set an activation function\n for all layers at once. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation private pure subroutine set_activation_layers (self, activation) A thin wrapper around layer % set_activation().\n This method can be used to set different activation functions\n for each layer separately. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self character(len=*), intent(in) :: activation (size(self%layers)) private subroutine sync (self, image) Broadcasts network weights and biases from\n specified image to all others. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self integer(kind=ik), intent(in) :: image private subroutine train_batch (self, x, y, eta) Trains a network using input data x and output data y,\n and learning rate eta. The learning rate is normalized\n with the size of the data batch.\n mini-batch size\n number of layers Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta private subroutine train_epochs (self, x, y, eta, num_epochs, batch_size) Trains for num_epochs epochs with mini-bachtes of size equal to batch_size. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:,:) real(kind=rk), intent(in) :: y (:,:) real(kind=rk), intent(in) :: eta integer(kind=ik), intent(in) :: num_epochs integer(kind=ik), intent(in) :: batch_size private pure subroutine train_single (self, x, y, eta) Trains a network using a single set of input data x and output data y,\n and learning rate eta. Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self real(kind=rk), intent(in) :: x (:) real(kind=rk), intent(in) :: y (:) real(kind=rk), intent(in) :: eta private pure subroutine update (self, dw, db, eta) Updates network weights and biases with gradients dw and db,\n scaled by learning rate eta.\n update biases\n update weights Arguments Type Intent Optional Attributes Name class( network_type ), intent(inout) :: self class( array2d ), intent(in) :: dw (:) class( array1d ), intent(in) :: db (:) real(kind=rk), intent(in) :: eta","tags":"","loc":"module/mod_network.html"},{"title":"mod_io – ","text":"Uses mod_kinds module~~mod_io~~UsesGraph module~mod_io mod_io module~mod_kinds mod_kinds module~mod_io->module~mod_kinds iso_fortran_env iso_fortran_env module~mod_kinds->iso_fortran_env Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Used by module~~mod_io~~UsedByGraph module~mod_io mod_io module~mod_mnist mod_mnist module~mod_mnist->module~mod_io Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Interfaces read_binary_file Subroutines read_binary_file_1d read_binary_file_2d Interfaces public interface read_binary_file private subroutine read_binary_file_1d (filename, dtype, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:) private subroutine read_binary_file_2d (filename, dtype, dsize, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: dsize integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:,:) Subroutines private subroutine read_binary_file_1d (filename, dtype, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:) private subroutine read_binary_file_2d (filename, dtype, dsize, nrec, array) Arguments Type Intent Optional Attributes Name character(len=*), intent(in) :: filename integer(kind=ik), intent(in) :: dtype integer(kind=ik), intent(in) :: dsize integer(kind=ik), intent(in) :: nrec real(kind=rk), intent(inout), allocatable :: array (:,:)","tags":"","loc":"module/mod_io.html"},{"title":"mod_activation – ","text":"A collection of activation functions and their derivatives. Uses mod_kinds module~~mod_activation~~UsesGraph module~mod_activation mod_activation module~mod_kinds mod_kinds module~mod_activation->module~mod_kinds iso_fortran_env iso_fortran_env module~mod_kinds->iso_fortran_env Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Used by module~~mod_activation~~UsedByGraph module~mod_activation mod_activation module~mod_layer mod_layer module~mod_layer->module~mod_activation module~mod_network mod_network module~mod_network->module~mod_layer Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Interfaces activation_function Functions gaussian gaussian_prime relu relu_prime sigmoid sigmoid_prime step step_prime tanh_prime tanhf Interfaces interface public pure function activation_function(x) Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) Functions public pure function gaussian (x) result(res) Gaussian activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function gaussian_prime (x) result(res) First derivative of the Gaussian activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function relu (x) result(res) REctified Linear Unit (RELU) activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function relu_prime (x) result(res) First derivative of the REctified Linear Unit (RELU) activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function sigmoid (x) result(res) Sigmoid activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function sigmoid_prime (x) result(res) First derivative of the sigmoid activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function step (x) result(res) Step activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function step_prime (x) result(res) First derivative of the step activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function tanh_prime (x) result(res) First derivative of the tanh activation function. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x)) public pure function tanhf (x) result(res) Tangent hyperbolic activation function. \n Same as the intrinsic tanh, but must be \n defined here so that we can use procedure\n pointer with it. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x (:) Return Value real(kind=rk)\n  (size(x))","tags":"","loc":"module/mod_activation.html"},{"title":"mod_mnist – ","text":"Procedures to work with MNIST dataset, usable with data format\n as provided in this repo and not the original data format (idx). TODO make MNIST work with arbitrary precision Uses mod_kinds iso_fortran_env mod_io module~~mod_mnist~~UsesGraph module~mod_mnist mod_mnist module~mod_io mod_io module~mod_mnist->module~mod_io module~mod_kinds mod_kinds module~mod_mnist->module~mod_kinds iso_fortran_env iso_fortran_env module~mod_mnist->iso_fortran_env module~mod_io->module~mod_kinds module~mod_kinds->iso_fortran_env Help × Graph Key Nodes of different colours represent the following: Graph Key Module Module Submodule Submodule Subroutine Subroutine Function Function Program Program This Page's Entity This Page's Entity Solid arrows point from a submodule to the (sub)module which it is\n    descended from. Dashed arrows point from a module or program unit to \n    modules which it uses. Where possible, edges connecting nodes are given different colours to make them easier to distinguish in large graphs. Contents Functions label_digits digits Subroutines load_mnist print_image Functions public pure function label_digits (labels) result(res) Converts an array of MNIST labels into a form\n that can be input to the network_type instance. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: labels (:) Return Value real(kind=rk)\n  (10,size(labels)) private pure function digits (x) Returns an array of 10 reals, with zeros everywhere\n and a one corresponding to the input number, for example:\n   digits(0) = [1., 0., 0., 0., 0., 0., 0., 0., 0., 0.]\n   digits(1) = [0., 1., 0., 0., 0., 0., 0., 0., 0., 0.]\n   digits(6) = [0., 0., 0., 0., 0., 0., 1., 0., 0., 0.] Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: x Return Value real(kind=rk)\n  (10) Subroutines public subroutine load_mnist (tr_images, tr_labels, te_images, te_labels, va_images, va_labels) Loads the MNIST dataset into arrays. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(inout), allocatable :: tr_images (:,:) real(kind=rk), intent(inout), allocatable :: tr_labels (:) real(kind=rk), intent(inout), allocatable :: te_images (:,:) real(kind=rk), intent(inout), allocatable :: te_labels (:) real(kind=rk), intent(inout), optional allocatable :: va_images (:,:) real(kind=rk), intent(inout), optional allocatable :: va_labels (:) public subroutine print_image (images, labels, n) Prints a single image and label to screen. Arguments Type Intent Optional Attributes Name real(kind=rk), intent(in) :: images (:,:) real(kind=rk), intent(in) :: labels (:) integer(kind=ik), intent(in) :: n","tags":"","loc":"module/mod_mnist.html"}]}