package com.example.securitydemo

import graphql.kickstart.tools.GraphQLQueryResolver
import org.springframework.security.access.prepost.PreAuthorize
import org.springframework.stereotype.Component

@Component
class GraphqlController: GraphQLQueryResolver {

    class Data(
        val value: String,
        val number: Int
    )

    @PreAuthorize("hasRole('ROLE_USER')")
    fun findData(): Data {
        return Data("Hello Word", 42)
    }
}