/*
 * Decompiled with CFR 0.152.
 */
package com.example.securitydemo;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u0007\u001a\u00020\bH\u0015J\b\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lcom/example/securitydemo/SecurityConfig;", "", "()V", "filterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "userDetailsService", "Lorg/springframework/security/provisioning/InMemoryUserDetailsManager;", "security-demo"})
public class SecurityConfig {
    @Bean
    @NotNull
    protected PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)new BCryptPasswordEncoder();
    }

    @Bean
    @NotNull
    public InMemoryUserDetailsManager userDetailsService() {
        String[] stringArray = new String[]{"ROLE_USER"};
        UserDetails user = User.withUsername((String)"user").password(this.passwordEncoder().encode((CharSequence)"password")).authorities(stringArray).build();
        stringArray = new UserDetails[]{user};
        return new InMemoryUserDetailsManager((UserDetails[])stringArray);
    }

    @Bean
    @NotNull
    public SecurityFilterChain filterChain(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        String[] stringArray = new String[]{"/graphql", "/api/**"};
        Object object = ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.securityMatcher(stringArray).cors().and()).csrf().disable()).authorizeHttpRequests(SecurityConfig::filterChain$lambda$0).httpBasic().and()).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"http\n            .securi\u2026           .and().build()");
        return (SecurityFilterChain)object;
    }

    private static final void filterChain$lambda$0(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorize) {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).hasRole("USER");
    }
}

